/*
 * Decompiled with CFR 0.152.
 */
package einstein.usefulslime.items;

import einstein.usefulslime.init.ModItems;
import einstein.usefulslime.util.BounceHandler;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SlimeSlingItem
extends Item {
    public SlimeSlingItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.success((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.onGround()) {
            return;
        }
        int timeUsed = this.getUseDuration(stack, entity) - timeLeft;
        float i = (float)timeUsed / 20.0f;
        i = (i * i + i * 2.0f) / 3.0f;
        if ((i *= 4.0f) > 6.0f) {
            i = 6.0f;
        }
        i *= 1.0f;
        BlockHitResult hitResult = SlimeSlingItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (hitResult != null) {
            if (hitResult.getType() == HitResult.Type.BLOCK) {
                Vec3 vec3 = player.getLookAngle().normalize();
                if (player.getItemBySlot(EquipmentSlot.CHEST).is(ModItems.SLIME_CHESTPLATE.get()) && player.getItemBySlot(EquipmentSlot.HEAD).is(ModItems.SLIME_HELMET.get())) {
                    i += 2.0f;
                }
                if (player.getItemBySlot(EquipmentSlot.FEET).is(ModItems.SLIME_BOOTS.get()) && player.getItemBySlot(EquipmentSlot.LEGS).is(ModItems.SLIME_LEGGINGS.get())) {
                    i += 2.0f;
                }
                if (player.isInWaterOrBubble()) {
                    i /= 2.0f;
                }
                player.push(vec3.x * (double)(-i), vec3.y * (double)(-i) / 3.0, vec3.z * (double)(-i));
                BounceHandler.addBounceHandler((LivingEntity)player);
                EquipmentSlot slot = stack.equals(player.getItemBySlot(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                stack.hurtAndBreak(1, (LivingEntity)player, slot);
            }
            if (i > 1.0f) {
                player.playSound(SoundEvents.SLIME_JUMP_SMALL, 1.0f, 1.0f);
            }
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredientStack) {
        return ingredientStack.is(Items.SLIME_BALL);
    }
}

