/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.screen.custom;

import com.benbenlaw.core.screen.util.CoreSlotTextures;
import com.benbenlaw.core.screen.util.slot.CoreSlot;
import com.benbenlaw.core.screen.util.slot.ResultSlot;
import com.benbenlaw.strainers.block.ModBlocks;
import com.benbenlaw.strainers.block.entity.WoodenStrainerBlockEntity;
import com.benbenlaw.strainers.screen.ModMenuTypes;
import com.benbenlaw.strainers.util.ModTags;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class WoodenStrainerMenu
extends AbstractContainerMenu {
    protected final WoodenStrainerBlockEntity blockEntity;
    protected final Level level;
    protected final ContainerData data;
    protected Player player;
    protected BlockPos blockPos;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 38;

    public WoodenStrainerMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, extraData.readBlockPos(), (ContainerData)new SimpleContainerData(38));
    }

    public WoodenStrainerMenu(int containerID, Inventory inventory, BlockPos blockPos, ContainerData data) {
        super((MenuType)ModMenuTypes.WOODEN_STRAINER_MENU.get(), containerID);
        this.player = inventory.player;
        this.blockPos = blockPos;
        this.level = inventory.player.level();
        this.blockEntity = (WoodenStrainerBlockEntity)this.level.getBlockEntity(blockPos);
        this.data = data;
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        assert (this.blockEntity != null);
        this.addSlot((Slot)new CoreSlot(this, (IItemHandler)this.blockEntity.getItemStackHandler(), 0, 8, 17){

            public boolean mayPlace(ItemStack stack) {
                return !stack.is(ModTags.Items.MESHES) && !stack.is(ModTags.Items.UPGRADES);
            }
        });
        this.addSlot((Slot)new CoreSlot(this, (IItemHandler)this.blockEntity.getItemStackHandler(), 1, 8, 35){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ModTags.Items.MESHES);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.getItemStackHandler(), 2, 8, 53){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)CoreSlotTextures.UPGRADE_SLOT);
            }

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ModTags.Items.UPGRADES);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.getItemStackHandler(), 3, 8, 71){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)CoreSlotTextures.UPGRADE_SLOT);
            }

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ModTags.Items.UPGRADES);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.getItemStackHandler(), 4, 8, 89){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)CoreSlotTextures.UPGRADE_SLOT);
            }

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ModTags.Items.UPGRADES);
            }
        });
        int OUTPUT_SLOT = 5;
        int xStart = 62;
        int yStart = 17;
        int xOffset = 18;
        int yOffset = 18;
        int rows = 2;
        int columns = 6;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                int xPos = xStart + col * xOffset;
                int yPos = yStart + row * yOffset;
                this.addSlot((Slot)new ResultSlot((IItemHandler)this.blockEntity.getItemStackHandler(), OUTPUT_SLOT++, xPos, yPos, 64));
            }
        }
        int OUTPUT_SLOT2 = 17;
        int xStart2 = 44;
        int yStart2 = 53;
        int rows2 = 3;
        int columns2 = 7;
        for (int row2 = 0; row2 < rows2; ++row2) {
            for (int col = 0; col < columns2; ++col) {
                int xPos = xStart2 + col * xOffset;
                int yPos = yStart2 + row2 * yOffset;
                this.addSlot((Slot)new ResultSlot((IItemHandler)this.blockEntity.getItemStackHandler(), OUTPUT_SLOT2++, xPos, yPos, 64));
            }
        }
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 24;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 74, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 74) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return WoodenStrainerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.blockPos), (Player)player, (Block)((Block)ModBlocks.WOODEN_STRAINER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 123 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 181));
        }
    }
}

