/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.recipe;

import com.benbenlaw.strainers.recipe.ModRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class TagOutputRecipe
extends ShapedRecipe {
    public final TagKey<Item> outputTag;
    private final int count;

    public TagOutputRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, TagKey<Item> outputTag, int count, boolean notification) {
        super(group, category, pattern, ItemStack.EMPTY, notification);
        this.outputTag = outputTag;
        this.count = count;
    }

    public ItemStack assemble(CraftingInput container, HolderLookup.Provider provider) {
        Optional<Item> item = BuiltInRegistries.ITEM.getTag(this.outputTag).flatMap(tag -> tag.stream().findFirst()).map(Holder::value);
        return item.map(value -> new ItemStack((ItemLike)value, this.count)).orElse(ItemStack.EMPTY);
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        Optional<Item> item = BuiltInRegistries.ITEM.getTag(this.outputTag).flatMap(tag -> tag.stream().findFirst()).map(Holder::value);
        return item.map(value -> new ItemStack((ItemLike)value, this.count)).orElse(ItemStack.EMPTY);
    }

    public TagKey<Item> outputTag() {
        return this.outputTag;
    }

    public int count() {
        return this.count;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.SHAPED_TAG_OUTPUT.get();
    }

    public static class Serializer
    implements RecipeSerializer<TagOutputRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<Pair<TagKey<Item>, Integer>> RESULT_CODEC = RecordCodecBuilder.mapCodec(pairInstance -> pairInstance.group((App)ResourceLocation.CODEC.fieldOf("tag").forGetter(pair -> ((TagKey)pair.getFirst()).location()), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(Pair::getSecond)).apply((Applicative)pairInstance, (tagLoc, count) -> Pair.of((Object)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagLoc), (Object)count)));
        public static final MapCodec<TagOutputRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").forGetter(ShapedRecipe::category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(r -> r.pattern), (App)RESULT_CODEC.fieldOf("result").forGetter(recipe -> Pair.of(recipe.outputTag, (Object)recipe.count)), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(ShapedRecipe::showNotification)).apply((Applicative)instance, (group, category, pattern, resultPair, showNotif) -> new TagOutputRecipe((String)group, (CraftingBookCategory)category, (ShapedRecipePattern)pattern, (TagKey<Item>)((TagKey)resultPair.getFirst()), (Integer)resultPair.getSecond(), (boolean)showNotif)));
        private final StreamCodec<RegistryFriendlyByteBuf, TagOutputRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<TagOutputRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, TagOutputRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static TagOutputRecipe read(RegistryFriendlyByteBuf buf) {
            String group = buf.readUtf();
            CraftingBookCategory category = (CraftingBookCategory)buf.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buf);
            ResourceLocation tagId = buf.readResourceLocation();
            int count = buf.readVarInt();
            boolean notification = buf.readBoolean();
            return new TagOutputRecipe(group, category, pattern, (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagId), count, notification);
        }

        private static void write(RegistryFriendlyByteBuf buf, TagOutputRecipe recipe) {
            buf.writeUtf(recipe.getGroup());
            buf.writeEnum((Enum)recipe.category());
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buf, (Object)recipe.pattern);
            buf.writeResourceLocation(recipe.outputTag.location());
            buf.writeVarInt(recipe.count);
            buf.writeBoolean(recipe.showNotification());
        }
    }

    public static class Type
    implements RecipeType<TagOutputRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

