/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class UpgradeItem
extends Item {
    private final int speedReduction;
    private final double outputIncrease;

    public UpgradeItem(Item.Properties properties, int speedReduction) {
        super(properties);
        this.outputIncrease = 0.0;
        this.speedReduction = speedReduction;
    }

    public UpgradeItem(Item.Properties properties, double outputIncrease) {
        super(properties);
        this.outputIncrease = outputIncrease;
        this.speedReduction = 0;
    }

    public int getSpeedReduction() {
        return this.speedReduction;
    }

    public double getOutputIncrease() {
        return this.outputIncrease;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            if (this.speedReduction == 0) {
                String outputIncrease = String.format("%.0f%%", this.outputIncrease * 100.0);
                components.add((Component)Component.translatable((String)"tooltip.strainers.output_increase", (Object[])new Object[]{outputIncrease}).withStyle(ChatFormatting.BLUE));
            } else {
                components.add((Component)Component.translatable((String)"tooltip.strainers.duration_decrease", (Object[])new Object[]{this.speedReduction}).withStyle(ChatFormatting.YELLOW));
            }
        } else {
            components.add((Component)Component.translatable((String)"tooltips.bblcore.shift").withStyle(ChatFormatting.YELLOW));
        }
    }
}

