/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.integration.jei;

import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.strainers.block.ModBlocks;
import com.benbenlaw.strainers.integration.jei.StrainerRecipeCategory;
import com.benbenlaw.strainers.integration.jei.StrainerRecipeDisplay;
import com.benbenlaw.strainers.recipe.MeshChanceResult;
import com.benbenlaw.strainers.recipe.ModRecipes;
import com.benbenlaw.strainers.recipe.StrainerRecipe;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIStrainersPlugin
implements IModPlugin {
    public static IDrawableStatic slotDrawable;
    public static RecipeType<StrainerRecipeDisplay> STRAINER;

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"strainers", (String)"jei_plugin");
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WOODEN_STRAINER.get()), new RecipeType[]{StrainerRecipeCategory.RECIPE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new StrainerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        slotDrawable = registration.getJeiHelpers().getGuiHelper().getSlotDrawable();
    }

    public void registerRecipes(IRecipeRegistration registration) {
        assert (Minecraft.getInstance().level != null);
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        List<StrainerRecipe> allRecipes = recipeManager.getAllRecipesFor(ModRecipes.STRAINER_TYPE.get()).stream().map(RecipeHolder::value).toList();
        List<StrainerRecipeDisplay> displays = JEIStrainersPlugin.mergeStrainerRecipes(allRecipes);
        displays.sort(Comparator.comparingDouble(d -> d.getChanceResults().stream().mapToDouble(ChanceResult::chance).min().orElse(0.0)));
        registration.addRecipes(StrainerRecipeCategory.RECIPE_TYPE, displays);
    }

    private static List<StrainerRecipeDisplay> mergeStrainerRecipes(List<StrainerRecipe> recipes) {
        HashMap<String, StrainerRecipeDisplay> merged = new HashMap<String, StrainerRecipeDisplay>();
        for (StrainerRecipe recipe : recipes) {
            for (MeshChanceResult meshChance : recipe.getRollResults()) {
                if (meshChance == MeshChanceResult.EMPTY) continue;
                String key = recipe.input().toString() + "|" + recipe.getBlockAbove().toString() + "|" + meshChance.mesh().toString();
                merged.compute(key, (k, existing) -> {
                    if (existing == null) {
                        return new StrainerRecipeDisplay(recipe.getBlockAbove(), recipe.input(), meshChance.mesh(), List.of(meshChance.chanceResult()));
                    }
                    ArrayList<ChanceResult> combined = new ArrayList<ChanceResult>(existing.getChanceResults());
                    combined.add(meshChance.chanceResult());
                    return new StrainerRecipeDisplay(existing.getAboveBlock(), existing.getInput(), existing.getMesh(), combined);
                });
            }
        }
        return new ArrayList<StrainerRecipeDisplay>(merged.values());
    }

    static {
        STRAINER = new RecipeType(StrainerRecipeCategory.UID, StrainerRecipeDisplay.class);
    }
}

