/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.config;

import com.mrbysco.structurecompass.StructureCompass;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class StructureConfig {
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        StructureCompass.LOGGER.debug("Loaded Structure Compass' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        StructureCompass.LOGGER.warn("Structure Compass' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.IntValue compassRange;
        public final ModConfigSpec.BooleanValue locateUnexplored;
        public final ModConfigSpec.BooleanValue locateAsync;
        public final ModConfigSpec.ConfigValue<List<? extends String>> structureBlacklist;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push("general");
            this.compassRange = builder.comment("Sets the range in blocks in which the structure compasses can locate structures [default: 10000]").defineInRange("compassRange", 10000, 0, Integer.MAX_VALUE);
            this.locateUnexplored = builder.comment("Defines if the structure compass should locate unexplored structures [default: false]").define("locateUnexplored", false);
            this.locateAsync = builder.comment("Defines if the structure compass should locate structures asynchronously [default: false]").define("locateAsync", false);
            this.structureBlacklist = builder.comment("Defines which structures can't be searched with the Structure Compass\n(Supports wildcard *, Example: 'minecraft:*' will blacklist anything in the minecraft domain)").defineListAllowEmpty(List.of("structureBlacklist"), () -> List.of(""), o -> o instanceof String);
            builder.pop();
        }
    }
}

