/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.cloche.screen;

import com.benbenlaw.cloche.block.ClocheBlocks;
import com.benbenlaw.cloche.block.entity.ClocheBlockEntity;
import com.benbenlaw.cloche.recipe.ClocheRecipe;
import com.benbenlaw.cloche.recipe.ClocheRecipes;
import com.benbenlaw.cloche.screen.ClocheMenus;
import com.benbenlaw.cloche.util.ClocheTags;
import com.benbenlaw.core.screen.util.CoreSlotTextures;
import com.benbenlaw.core.screen.util.slot.CoreSlot;
import com.benbenlaw.core.screen.util.slot.ResultSlot;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ClocheMenu
extends AbstractContainerMenu {
    protected ClocheBlockEntity blockEntity;
    protected Level level;
    protected ContainerData data;
    protected Player player;
    protected BlockPos blockPos;
    public int numberOfCatalysts = 0;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 18;

    public ClocheMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, extraData.readBlockPos(), (ContainerData)new SimpleContainerData(2));
    }

    public ClocheMenu(int containerID, Inventory inventory, BlockPos blockPos, ContainerData data) {
        super((MenuType)ClocheMenus.CLOCHE_MENU.get(), containerID);
        this.player = inventory.player;
        this.blockPos = blockPos;
        this.level = inventory.player.level();
        this.blockEntity = (ClocheBlockEntity)this.level.getBlockEntity(blockPos);
        this.data = data;
        ClocheBlockEntity entity = (ClocheBlockEntity)this.level.getBlockEntity(blockPos);
        ClocheMenu.checkContainerSize((Container)inventory, (int)18);
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        assert (entity != null);
        this.addSlot((Slot)new CoreSlot((IItemHandler)entity.getItemStackHandler(), 0, 8, 17){

            @NotNull
            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)CoreSlotTextures.SEED_SLOT);
            }

            public boolean mayPlace(ItemStack stack) {
                return ClocheMenu.this.isValidSeed(stack);
            }
        });
        this.addSlot((Slot)new CoreSlot((IItemHandler)entity.getItemStackHandler(), 1, 8, 35){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)CoreSlotTextures.BLOCK_SLOT);
            }

            public boolean mayPlace(ItemStack stack) {
                return ClocheMenu.this.isValidSoil(stack);
            }
        });
        this.addSlot((Slot)new CoreSlot((IItemHandler)entity.getItemStackHandler(), 2, 8, 53){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)CoreSlotTextures.CATALYST_SLOT);
            }

            public boolean mayPlace(ItemStack stack) {
                return ClocheMenu.this.isValidCatalyst(stack);
            }
        });
        this.addSlot((Slot)new CoreSlot(this, (IItemHandler)entity.getItemStackHandler(), 3, 35, 53){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)CoreSlotTextures.UPGRADE_SLOT);
            }

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ClocheTags.Items.UPGRADES);
            }
        });
        this.addSlot((Slot)new CoreSlot(this, (IItemHandler)entity.getItemStackHandler(), 4, 53, 53){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)CoreSlotTextures.UPGRADE_SLOT);
            }

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ClocheTags.Items.UPGRADES);
            }
        });
        this.addSlot((Slot)new CoreSlot(this, (IItemHandler)entity.getItemStackHandler(), 5, 71, 53){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)CoreSlotTextures.UPGRADE_SLOT);
            }

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ClocheTags.Items.UPGRADES);
            }
        });
        int OUTPUT_SLOT = 6;
        int xStart = 98;
        int yStart = 17;
        int xOffset = 18;
        int yOffset = 18;
        int rows = 3;
        int columns = 4;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                int xPos = xStart + col * xOffset;
                int yPos = yStart + row * yOffset;
                this.addSlot((Slot)new ResultSlot((IItemHandler)this.blockEntity.getItemStackHandler(), OUTPUT_SLOT++, xPos, yPos, 64));
            }
        }
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 26;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public int getProgress() {
        return this.data.get(0);
    }

    public int getMaxProgress() {
        return this.data.get(1);
    }

    public Map<String, List<Ingredient>> getAllSoilOptions() {
        HashMap<String, List<Ingredient>> options = new HashMap<String, List<Ingredient>>();
        ArrayList soilOptions = new ArrayList();
        ArrayList seedOptions = new ArrayList();
        ArrayList catalystOptions = new ArrayList();
        this.level.getRecipeManager().getAllRecipesFor(ClocheRecipes.CLOCHE_TYPE.get()).forEach(recipe -> {
            soilOptions.add(((ClocheRecipe)recipe.value()).getSoil());
            seedOptions.add(((ClocheRecipe)recipe.value()).getSeed());
            catalystOptions.add(((ClocheRecipe)recipe.value()).getCatalyst());
        });
        this.numberOfCatalysts = catalystOptions.size();
        options.put("soil", soilOptions);
        options.put("seed", seedOptions);
        options.put("catalyst", catalystOptions);
        return options;
    }

    public boolean isValidSoil(ItemStack stack) {
        return this.getAllSoilOptions().get("soil").stream().anyMatch(ingredient -> ingredient.test(stack));
    }

    public boolean isValidSeed(ItemStack stack) {
        return this.getAllSoilOptions().get("seed").stream().anyMatch(ingredient -> ingredient.test(stack));
    }

    public boolean isValidCatalyst(ItemStack stack) {
        return this.getAllSoilOptions().get("catalyst").stream().anyMatch(ingredient -> ingredient.test(stack));
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 54, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 54) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return ClocheMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.blockPos), (Player)player, (Block)((Block)ClocheBlocks.CLOCHE.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

