/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.cloche.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record DimensionalUpgradeRecipe(Ingredient ingredient, String dimension) implements Recipe<RecipeInput>
{
    public boolean matches(@NotNull RecipeInput container, @NotNull Level level) {
        ItemStack upgradeSlot1 = container.getItem(3);
        ItemStack upgradeSlot2 = container.getItem(4);
        ItemStack upgradeSlot3 = container.getItem(5);
        return this.ingredient.test(upgradeSlot1) || this.ingredient.test(upgradeSlot2) || this.ingredient.test(upgradeSlot3);
    }

    public ItemStack assemble(RecipeInput p_345149_, HolderLookup.Provider p_346030_) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_336125_) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<DimensionalUpgradeRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<DimensionalUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(DimensionalUpgradeRecipe::ingredient), (App)Codec.STRING.fieldOf("dimension").forGetter(DimensionalUpgradeRecipe::dimension)).apply((Applicative)instance, DimensionalUpgradeRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, DimensionalUpgradeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<DimensionalUpgradeRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, DimensionalUpgradeRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static DimensionalUpgradeRecipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            String dimension = buffer.readUtf(Short.MAX_VALUE);
            return new DimensionalUpgradeRecipe(ingredient, dimension);
        }

        private static void write(RegistryFriendlyByteBuf buffer, DimensionalUpgradeRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            buffer.writeUtf(recipe.dimension);
        }
    }

    public static class Type
    implements RecipeType<DimensionalUpgradeRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

