/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.cloche.event.client;

import com.benbenlaw.cloche.recipe.DimensionalUpgradeRecipe;
import com.benbenlaw.cloche.recipe.SpeedUpgradeRecipe;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="cloche", value={Dist.CLIENT})
public class SpeedUpgradeTooltip {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        MutableComponent newTooltip;
        ItemStack upgradeStack = event.getItemStack();
        List components = event.getToolTip();
        if (event.getEntity() == null) {
            return;
        }
        Level level = event.getEntity().level();
        List speedRecipe = level.getRecipeManager().getAllRecipesFor((RecipeType)SpeedUpgradeRecipe.Type.INSTANCE);
        List dimensionRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)DimensionalUpgradeRecipe.Type.INSTANCE);
        for (RecipeHolder recipeHolder : speedRecipe) {
            SpeedUpgradeRecipe speedUpgradeRecipe = (SpeedUpgradeRecipe)recipeHolder.value();
            if (!speedUpgradeRecipe.ingredient().test(upgradeStack)) continue;
            if (Screen.hasShiftDown()) {
                newTooltip = SpeedUpgradeTooltip.getMutableComponent(speedUpgradeRecipe);
                components.add(newTooltip.withStyle(ChatFormatting.YELLOW));
                continue;
            }
            components.add(Component.translatable((String)"tooltips.bblcore.shift").withStyle(ChatFormatting.YELLOW));
        }
        for (RecipeHolder recipeHolder : dimensionRecipes) {
            DimensionalUpgradeRecipe dimensionalUpgradeRecipe = (DimensionalUpgradeRecipe)recipeHolder.value();
            if (!dimensionalUpgradeRecipe.ingredient().test(upgradeStack)) continue;
            if (Screen.hasShiftDown()) {
                newTooltip = SpeedUpgradeTooltip.getMutableComponent(dimensionalUpgradeRecipe);
                components.add(newTooltip.withStyle(ChatFormatting.YELLOW));
                break;
            }
            components.add(Component.translatable((String)"tooltips.bblcore.shift").withStyle(ChatFormatting.YELLOW));
        }
    }

    @NotNull
    private static MutableComponent getMutableComponent(DimensionalUpgradeRecipe dimensionalUpgradeRecipe) {
        String dimensionName = dimensionalUpgradeRecipe.dimension();
        MutableComponent dimensionNameTranslated = Component.translatable((String)dimensionName);
        String translatedDimensionName = dimensionNameTranslated.getString();
        Object displayDimensionName = translatedDimensionName.startsWith("The ") ? translatedDimensionName : "The " + translatedDimensionName;
        return Component.translatable((String)"tooltip.cloche.upgrade.dimension", (Object[])new Object[]{displayDimensionName});
    }

    @NotNull
    private static MutableComponent getMutableComponent(SpeedUpgradeRecipe speedUpgradeRecipe) {
        int durationReduction = speedUpgradeRecipe.duration();
        String modifierType = speedUpgradeRecipe.modifierType();
        MutableComponent newTooltip = Component.empty();
        if (Objects.equals(modifierType, "percentage")) {
            newTooltip = Component.translatable((String)"tooltip.cloche.upgrade.percentage_speed_upgrade", (Object[])new Object[]{durationReduction});
        }
        if (Objects.equals(modifierType, "fixed")) {
            newTooltip = Component.translatable((String)"tooltip.cloche.upgrade.fixed_speed_upgrade", (Object[])new Object[]{durationReduction});
        }
        return newTooltip;
    }
}

