/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.cloche.data.recipe;

import com.benbenlaw.cloche.recipe.ClocheRecipe;
import com.benbenlaw.core.recipe.ChanceResult;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClocheRecipeProvider
implements RecipeBuilder {
    protected String group;
    protected Ingredient seed;
    protected Ingredient soil;
    protected Ingredient catalyst;
    protected String dimension;
    protected int duration;
    protected NonNullList<ChanceResult> results;
    protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    protected ItemStack shearsResult;

    public ClocheRecipeProvider(Ingredient seed, Ingredient soil, Ingredient catalyst, String dimension, int duration, NonNullList<ChanceResult> results, ItemStack shearsResult) {
        this.seed = seed;
        this.soil = soil;
        this.catalyst = catalyst != null ? catalyst : Ingredient.of((ItemStack[])new ItemStack[]{ItemStack.EMPTY});
        this.dimension = dimension != null ? dimension : "all";
        this.duration = duration;
        this.results = results;
        this.shearsResult = shearsResult != null ? shearsResult : ItemStack.EMPTY;
    }

    public static ClocheRecipeProvider ClocheRecipeBuilder(Ingredient seed, Ingredient soil, Ingredient catalyst, String dimension, int duration, NonNullList<ChanceResult> results, ItemStack shearsResult) {
        return new ClocheRecipeProvider(seed, soil, catalyst, dimension, duration, results, shearsResult);
    }

    @NotNull
    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public RecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    @NotNull
    public Item getResult() {
        return ((ChanceResult)this.results.getFirst()).stack().getItem();
    }

    public void save(@NotNull RecipeOutput recipeOutput) {
        this.save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"cloche", (String)"cloche/"));
    }

    public void save(@NotNull RecipeOutput recipeOutput, @NotNull ResourceLocation id) {
        Advancement.Builder builder = Advancement.Builder.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        ClocheRecipe clocheRecipe = new ClocheRecipe(this.seed, this.soil, this.catalyst, this.dimension, this.duration, this.results, this.shearsResult);
        recipeOutput.accept(id, (Recipe)clocheRecipe, builder.build(id.withPrefix("recipes/cloche/")));
    }
}

