/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.cloche.data;

import com.benbenlaw.cloche.data.ClocheBlockStatesProvider;
import com.benbenlaw.cloche.data.ClocheBlockTags;
import com.benbenlaw.cloche.data.ClocheItemModelProvider;
import com.benbenlaw.cloche.data.ClocheItemTags;
import com.benbenlaw.cloche.data.ClocheLootTableProvider;
import com.benbenlaw.cloche.data.ClocheRecipesData;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="cloche", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ClocheRecipesData(packOutput, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ClocheLootTableProvider::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        ClocheBlockTags blockTags = new ClocheBlockTags(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        ClocheItemTags itemTags = new ClocheItemTags(packOutput, lookupProvider, blockTags, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)itemTags);
        generator.addProvider(event.includeClient(), (DataProvider)new ClocheItemModelProvider(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new ClocheBlockStatesProvider(packOutput, event.getExistingFileHelper()));
    }
}

