/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.supermartijn642.fusion.entity.EntityModelModifierManager;
import com.supermartijn642.fusion.entity.EntityModelModifierReloadListener;
import com.supermartijn642.fusion.entity.model.FusionModelPart;
import com.supermartijn642.fusion.entity.model.loader.FusionEntityModelLoader;
import com.supermartijn642.fusion.entity.model.predicates.EntityModelPredicateRegistry;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityModelSet.class})
public class EntityModelSetMixin {
    @Shadow
    private Map<ModelLayerLocation, LayerDefinition> roots;

    @ModifyReturnValue(method={"bakeLayer"}, at={@At(value="RETURN")})
    private ModelPart trackBakedModel(ModelPart part, ModelLayerLocation location) {
        FusionModelPart fusionModelPart = EntityModelModifierManager.handleModelBake(location, part);
        return fusionModelPart == null ? part : fusionModelPart;
    }

    @Inject(method={"onResourceManagerReload"}, at={@At(value="TAIL")})
    private void loadFusionEntityModels(ResourceManager resourceManager, CallbackInfo ci) {
        EntityModelPredicateRegistry.finalizeRegistration();
        HashSet<ResourceLocation> locations = new HashSet<ResourceLocation>();
        EntityModelModifierReloadListener.reload(resourceManager);
        EntityModelModifierReloadListener.getModelLocations(locations::add);
        for (ModelLayerLocation layer : this.roots.keySet()) {
            locations.add(FusionEntityModelLoader.locationForLayer(layer));
        }
        List<ResourceLocation> locationsSorted = locations.stream().sorted(Comparator.comparing(ResourceLocation::toString)).toList();
        FusionEntityModelLoader.loadModels(locationsSorted, resourceManager);
        EntityModelModifierManager.bakeModels(this.roots);
    }
}

