/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.ClientEvents;
import com.darkere.crashutils.CrashUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record OpenPlayerInvMessage(Map<String, Integer> slotAmounts, String otherPlayerName, int windowID) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenPlayerInvMessage> TYPE = new CustomPacketPayload.Type(CrashUtils.ResourceLocation("openplayerinvmessage"));
    public static final StreamCodec<? super RegistryFriendlyByteBuf, OpenPlayerInvMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(LinkedHashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.INT), OpenPlayerInvMessage::slotAmounts, (StreamCodec)ByteBufCodecs.STRING_UTF8, OpenPlayerInvMessage::otherPlayerName, (StreamCodec)ByteBufCodecs.INT, OpenPlayerInvMessage::windowID, OpenPlayerInvMessage::new);

    public static boolean handle(OpenPlayerInvMessage data, IPayloadContext ctx) {
        ClientEvents.openContainerAndScreen(data.windowID, data.otherPlayerName, data.slotAmounts);
        return true;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

