/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class RenderUtils {
    public static void drawFlatColoredSphere(Matrix4f pose, MultiBufferSource bufferSource, float radius, float originX, float originY, float originZ, float r, float g, float b, float a) {
        RenderUtils.drawSphere(pose, bufferSource.getBuffer(RenderType.debugQuads()), radius, originX, originY, originZ, 15.0f, 15.0f, (pose1, consumer1, x0, y0, z0, x1, y1, z1, x2, y2, z2, x3, y3, z3) -> {
            consumer1.addVertex(pose1, x0, y0, z0).setColor(r, g, b, a);
            consumer1.addVertex(pose1, x1, y1, z1).setColor(r, g, b, a);
            consumer1.addVertex(pose1, x2, y2, z2).setColor(r, g, b, a);
            consumer1.addVertex(pose1, x3, y3, z3).setColor(r, g, b, a);
            consumer1.addVertex(pose1, x3, y3, z3).setColor(r, g, b, a);
            consumer1.addVertex(pose1, x2, y2, z2).setColor(r, g, b, a);
            consumer1.addVertex(pose1, x1, y1, z1).setColor(r, g, b, a);
            consumer1.addVertex(pose1, x0, y0, z0).setColor(r, g, b, a);
        });
    }

    public static void drawSphere(Matrix4f pose, VertexConsumer consumer, float radius, float originX, float originY, float originZ, float rings, float segments, SphereDrawHandler sphereDrawHandler) {
        float ringStep = (float)Math.PI / rings;
        float segmentStep = (float)Math.PI * 2 / segments;
        int ring = 0;
        while ((float)ring < rings) {
            float theta = (float)ring * ringStep;
            float nextTheta = (float)(ring + 1) * ringStep;
            int segment = 0;
            while ((float)segment < segments) {
                float phi = (float)segment * segmentStep;
                float nextPhi = (float)(segment + 1) * segmentStep;
                float x0 = originX + radius * Mth.sin((float)theta) * Mth.cos((float)phi);
                float y0 = originY + radius * Mth.cos((float)theta);
                float z0 = originZ + radius * Mth.sin((float)theta) * Mth.sin((float)phi);
                float x1 = originX + radius * Mth.sin((float)theta) * Mth.cos((float)nextPhi);
                float y1 = originY + radius * Mth.cos((float)theta);
                float z1 = originZ + radius * Mth.sin((float)theta) * Mth.sin((float)nextPhi);
                float x2 = originX + radius * Mth.sin((float)nextTheta) * Mth.cos((float)nextPhi);
                float y2 = originY + radius * Mth.cos((float)nextTheta);
                float z2 = originZ + radius * Mth.sin((float)nextTheta) * Mth.sin((float)nextPhi);
                float x3 = originX + radius * Mth.sin((float)nextTheta) * Mth.cos((float)phi);
                float y3 = originY + radius * Mth.cos((float)nextTheta);
                float z3 = originZ + radius * Mth.sin((float)nextTheta) * Mth.sin((float)phi);
                sphereDrawHandler.draw(pose, consumer, x0, y0, z0, x1, y1, z1, x2, y2, z2, x3, y3, z3);
                ++segment;
            }
            ++ring;
        }
    }

    public static void drawRing(Matrix4f pose, MultiBufferSource bufferSource, float distance, float originX, float originY, float originZ, float r, float g, float b, float a) {
        RenderUtils.drawRing(pose, bufferSource.getBuffer(RenderType.debugQuads()), distance, originX, originY, originZ, 15, 2.0f, (pose1, vertexConsumer1, x1, y1, z1, x2, z2, y2) -> {
            vertexConsumer1.addVertex(pose, x1, y1, z1).setColor(r, g, b, a);
            vertexConsumer1.addVertex(pose, x2, y1, z2).setColor(r, g, b, a);
            vertexConsumer1.addVertex(pose, x2, y2, z2).setColor(r, g, b, a);
            vertexConsumer1.addVertex(pose, x1, y2, z1).setColor(r, g, b, a);
            vertexConsumer1.addVertex(pose, x1, y2, z1).setColor(r, g, b, a);
            vertexConsumer1.addVertex(pose, x2, y2, z2).setColor(r, g, b, a);
            vertexConsumer1.addVertex(pose, x2, y1, z2).setColor(r, g, b, a);
            vertexConsumer1.addVertex(pose, x1, y1, z1).setColor(r, g, b, a);
        });
    }

    public static void drawRing(Matrix4f pose, VertexConsumer vertexConsumer, float distance, float originX, float originY, float originZ, int segments, float ringHeight, RingDrawHandler ringDrawHandler) {
        float multiplier = (float)Math.PI * 2;
        for (int segmentIdx = 0; segmentIdx < segments; ++segmentIdx) {
            float hPct = (float)segmentIdx / (float)segments;
            float nextHPct = (float)(segmentIdx + 1) / (float)segments;
            float startX = Mth.sin((float)(hPct * multiplier)) * distance;
            float startZ = Mth.cos((float)(hPct * multiplier)) * distance;
            float endX = Mth.sin((float)(nextHPct * multiplier)) * distance;
            float endZ = Mth.cos((float)(nextHPct * multiplier)) * distance;
            float x1 = originX + startX;
            float y1 = originY + ringHeight;
            float z1 = originZ + startZ;
            float x2 = originX + endX;
            float y2 = originY - ringHeight;
            float z2 = originZ + endZ;
            ringDrawHandler.draw(pose, vertexConsumer, x1, y1, z1, x2, z2, y2);
        }
    }

    @FunctionalInterface
    public static interface SphereDrawHandler {
        public void draw(Matrix4f var1, VertexConsumer var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14);
    }

    @FunctionalInterface
    public static interface RingDrawHandler {
        public void draw(Matrix4f var1, VertexConsumer var2, float var3, float var4, float var5, float var6, float var7, float var8);
    }
}

