/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.util;

import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class SidedInputOutputItemHandler
implements IItemHandlerModifiable {
    private final IItemHandlerModifiable handler;
    private final Direction direction;
    private final TriPredicate<Direction, Integer, ItemStack> canInput;
    private final BiPredicateWithSide canOutput;

    public SidedInputOutputItemHandler(IItemHandlerModifiable handler, Direction direction, TriPredicate<Direction, Integer, ItemStack> canInput, BiPredicateWithSide canOutput) {
        this.handler = handler;
        this.direction = direction;
        this.canInput = canInput;
        this.canOutput = canOutput;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.handler.setStackInSlot(slot, stack);
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.handler.getStackInSlot(slot);
    }

    public int getSlots() {
        return this.handler.getSlots();
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.canInput.test(this.direction, slot, stack) ? this.handler.insertItem(slot, stack, simulate) : stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.canOutput.test(this.direction, slot) ? this.handler.extractItem(slot, amount, simulate) : ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return this.handler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.canInput.test(this.direction, slot, stack) && this.handler.isItemValid(slot, stack);
    }

    @FunctionalInterface
    public static interface TriPredicate<A, B, C> {
        public boolean test(A var1, B var2, C var3);
    }

    @FunctionalInterface
    public static interface BiPredicateWithSide {
        public boolean test(Direction var1, int var2);
    }
}

