/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.screen.util;

import com.benbenlaw.casting.util.MultiFluidTankSharedCapacity;
import com.benbenlaw.core.screen.util.CoreWidget;
import com.benbenlaw.core.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MultiFluidStackWidget
extends CoreWidget {
    private final Screen screen;
    private final MultiFluidTankSharedCapacity multiFluidTank;

    public MultiFluidStackWidget(Screen screen, MultiFluidTankSharedCapacity multiFluidTank, int pX, int pY, int pWidth, int pHeight) {
        super(pX, pY, pWidth, pHeight);
        this.screen = screen;
        this.multiFluidTank = multiFluidTank;
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        if (this.multiFluidTank == null) {
            return;
        }
        List<FluidStack> fluids = this.multiFluidTank.getFluids();
        this.renderToolTip(guiGraphics, mouseX, mouseY);
        int totalCapacity = this.multiFluidTank.getTankCapacity(1);
        int yOffset = this.height;
        for (FluidStack fluidStack : fluids) {
            int drawHeight;
            if (fluidStack.isEmpty()) continue;
            IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            ResourceLocation still = props.getStillTexture(fluidStack);
            AbstractTexture texture = minecraft.getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS);
            if (!(texture instanceof TextureAtlas)) continue;
            TextureAtlas atlas = (TextureAtlas)texture;
            TextureAtlasSprite sprite = atlas.getSprite(still);
            int color = props.getTintColor();
            RenderSystem.setShaderColor((float)((float)FastColor.ARGB32.red((int)color) / 255.0f), (float)((float)FastColor.ARGB32.green((int)color) / 255.0f), (float)((float)FastColor.ARGB32.blue((int)color) / 255.0f), (float)((float)FastColor.ARGB32.alpha((int)color) / 255.0f));
            RenderSystem.enableBlend();
            int fluidAmount = fluidStack.getAmount();
            float filledRatio = (float)fluidAmount / (float)totalCapacity;
            int renderableHeight = Math.max(1, (int)(filledRatio * (float)this.height));
            int atlasWidth = (int)((float)sprite.contents().width() / (sprite.getU1() - sprite.getU0()));
            int atlasHeight = (int)((float)sprite.contents().height() / (sprite.getV1() - sprite.getV0()));
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 0.0f);
            for (int remainingHeight = renderableHeight; remainingHeight > 0; remainingHeight -= drawHeight) {
                drawHeight = Math.min(16, remainingHeight);
                int drawY = yOffset - drawHeight;
                int notDrawn = 16 - drawHeight;
                int drawWidth = this.width;
                int repeatCount = (int)Math.ceil((double)drawWidth / 16.0);
                int drawnWidth = 0;
                for (int i = 0; i < repeatCount; ++i) {
                    int segmentWidth = Math.min(16, drawWidth - drawnWidth);
                    int uOffset = i * 16;
                    if (drawnWidth >= drawWidth) continue;
                    guiGraphics.blit(TextureAtlas.LOCATION_BLOCKS, this.x + drawnWidth, this.y + drawY, 0, (sprite.getU0() + (float)(i * 16)) * (float)atlasWidth, sprite.getV0() * (float)atlasHeight + (float)notDrawn, segmentWidth, drawHeight, atlasWidth, atlasHeight);
                    drawnWidth += segmentWidth;
                }
                yOffset -= drawHeight;
            }
            guiGraphics.pose().popPose();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
    }

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }

    public void renderToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)this.x, (int)this.y, (int)0, (int)-1, (int)this.width, (int)this.height)) {
            Font font = this.screen.getMinecraft().font;
            ArrayList<FormattedCharSequence> tooltipText = new ArrayList<FormattedCharSequence>();
            List<FluidStack> fluids = this.multiFluidTank.getFluids();
            int totalCapacity = this.multiFluidTank.getTankCapacity(1);
            int usedAmount = fluids.stream().mapToInt(FluidStack::getAmount).sum();
            int yOffset = this.y + this.height;
            boolean foundFluid = false;
            if (fluids.isEmpty()) {
                tooltipText.add(Component.literal((String)"Air").getVisualOrderText());
                tooltipText.add(Component.literal((String)("0mB / " + totalCapacity + "mB")).getVisualOrderText());
            } else {
                for (FluidStack fluid : fluids) {
                    if (fluid.isEmpty()) continue;
                    int fluidAmount = fluid.getAmount();
                    float ratio = (float)fluidAmount / (float)totalCapacity;
                    int height = Math.max(1, (int)(ratio * (float)this.height));
                    int top = yOffset - height;
                    if (mouseY >= top && mouseY <= yOffset) {
                        tooltipText.add(fluid.getHoverName().getVisualOrderText());
                        tooltipText.add(Component.literal((String)(fluidAmount + "mB")).getVisualOrderText());
                        foundFluid = true;
                        break;
                    }
                    yOffset -= height;
                }
                if (!foundFluid) {
                    tooltipText.add(Component.literal((String)"Capacity").getVisualOrderText());
                    tooltipText.add(Component.literal((String)(usedAmount + "mB / " + totalCapacity + "mB")).getVisualOrderText());
                }
            }
            if (!tooltipText.isEmpty()) {
                guiGraphics.renderTooltip(font, tooltipText, mouseX, mouseY);
            }
        }
    }
}

