/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.screen;

import com.benbenlaw.casting.block.entity.TankBlockEntity;
import com.benbenlaw.casting.item.CastingItems;
import com.benbenlaw.casting.network.payload.ClearTankPayload;
import com.benbenlaw.casting.network.payload.FluidMoverPayload;
import com.benbenlaw.casting.screen.EquipmentModifierMenu;
import com.benbenlaw.casting.screen.util.FluidStackWidgetBigTank;
import com.benbenlaw.core.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class EquipmentModifierScreen
extends AbstractContainerScreen<EquipmentModifierMenu> {
    private Level level;
    private BlockEntity fuelTankEntity;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/equipment_modifier_gui.png");

    public EquipmentModifierScreen(EquipmentModifierMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.level = menu.level;
        for (Direction direction : Direction.values()) {
            BlockEntity adjacentEntity = this.level.getBlockEntity(menu.blockEntity.getBlockPos().relative(direction));
            if (adjacentEntity instanceof TankBlockEntity) {
                TankBlockEntity tankBlockEntity = (TankBlockEntity)adjacentEntity;
                this.fuelTankEntity = this.level.getBlockEntity(tankBlockEntity.getBlockPos());
                break;
            }
            this.fuelTankEntity = null;
        }
    }

    protected void init() {
        super.init();
        this.addFluidWidgets();
    }

    private void addFluidWidgets() {
        this.addRenderableOnly((Renderable)new FluidStackWidgetBigTank((Screen)this, ((EquipmentModifierMenu)this.getMenu()).blockEntity.TANK, this.leftPos + 27, this.topPos + 15, 14, 56));
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        this.renderProgressBars(guiGraphics);
        int x = this.leftPos;
        int y = this.topPos;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderProgressBars(guiGraphics);
        this.renderWarning(guiGraphics, mouseX, mouseY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderProgressBars(GuiGraphics guiGraphics) {
        int x = this.leftPos;
        int y = this.topPos;
        guiGraphics.blit(TEXTURE, x + 107, y + 34, 176, 30, ((EquipmentModifierMenu)this.menu).getScaledProgress(), 16);
    }

    private void renderTickRate(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)80, (int)36, (int)90, (int)16)) {
            guiGraphics.drawString(this.font, ((EquipmentModifierMenu)this.menu).blockEntity.maxProgress + " ticks", this.leftPos + 120, this.topPos + 68, 0x3F3F3F, false);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean handled = super.mouseClicked(mouseX, mouseY, mouseButton);
        ItemStack heldItem = ((EquipmentModifierMenu)this.menu).getCarried();
        boolean isHoldingBucket = heldItem.is(CastingItems.FLUID_MOVER);
        int tankX = this.leftPos + 27;
        int tankY = this.topPos + 15;
        int tankWidth = 14;
        int tankHeight = 56;
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX, (int)tankY, (int)tankWidth, (int)tankHeight)) {
            int tank = ((EquipmentModifierMenu)this.menu).blockEntity.TANK.getTanks();
            boolean hasShiftDown = EquipmentModifierScreen.hasShiftDown();
            if (isHoldingBucket) {
                PacketDistributor.sendToServer((CustomPacketPayload)new FluidMoverPayload(((EquipmentModifierMenu)this.menu).blockEntity.getBlockPos(), tank), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new ClearTankPayload(((EquipmentModifierMenu)this.menu).blockEntity.getBlockPos(), hasShiftDown, tank), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return handled;
    }

    private void renderWarning(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int tankHeight;
        int tankWidth;
        int tankY;
        int tankX;
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)(this.leftPos + 106), (int)(this.topPos + 35), (int)27, (int)18) && !((EquipmentModifierMenu)this.menu).blockEntity.errorMessage.isEmpty()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)("gui.casting.buttons." + ((EquipmentModifierMenu)this.menu).blockEntity.errorMessage)).withStyle(ChatFormatting.RED), mouseX, mouseY);
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)(tankX = this.leftPos + 27), (int)(tankY = this.topPos + 15), (int)(tankWidth = 14), (int)(tankHeight = 56)) && EquipmentModifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.dump_fluid").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX, (int)tankY, (int)tankWidth, (int)tankHeight) && !EquipmentModifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.shift_dump_fluid").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
    }
}

