/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public record EquipmentModifierRecipe(SizedIngredient upgradeItem, FluidStack upgradeFluid, String effect) implements Recipe<RecipeInput>
{
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.add((Object)this.upgradeItem.ingredient());
        return ingredients;
    }

    public boolean matches(@NotNull RecipeInput container, @NotNull Level level) {
        return true;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean requiresBothItemAndFluid() {
        return !this.upgradeItem.ingredient().isEmpty() && !this.upgradeFluid.isEmpty();
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput container, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public FluidStack getFluidStack() {
        return this.upgradeFluid.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<EquipmentModifierRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<EquipmentModifierRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedIngredient.FLAT_CODEC.optionalFieldOf("upgrade_item", (Object)SizedIngredient.of((ItemLike)ItemStack.EMPTY.getItem(), (int)1)).forGetter(EquipmentModifierRecipe::upgradeItem), (App)FluidStack.OPTIONAL_CODEC.optionalFieldOf("upgrade_fluid", (Object)FluidStack.EMPTY).forGetter(EquipmentModifierRecipe::upgradeFluid), (App)Codec.STRING.fieldOf("effect").forGetter(EquipmentModifierRecipe::effect)).apply((Applicative)instance, Serializer::createToolModifierRecipe));
        private static final StreamCodec<RegistryFriendlyByteBuf, EquipmentModifierRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<EquipmentModifierRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, EquipmentModifierRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static EquipmentModifierRecipe read(RegistryFriendlyByteBuf buffer) {
            SizedIngredient upgradeItem = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            FluidStack upgradeFluid = (FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            String effect = buffer.readUtf();
            return new EquipmentModifierRecipe(upgradeItem, upgradeFluid, effect);
        }

        private static void write(RegistryFriendlyByteBuf buffer, EquipmentModifierRecipe recipe) {
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.upgradeItem);
            FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.upgradeFluid);
            buffer.writeUtf(recipe.effect);
        }

        static EquipmentModifierRecipe createToolModifierRecipe(SizedIngredient upgradeItem, FluidStack upgradeFluid, String effect) {
            return new EquipmentModifierRecipe(upgradeItem, upgradeFluid, effect);
        }
    }

    public static class Type
    implements RecipeType<EquipmentModifierRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

