/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.event.client;

import com.benbenlaw.casting.network.packet.JetJumpPacket;
import com.benbenlaw.casting.network.payload.ToggleArmorModifiersPayload;
import com.benbenlaw.casting.util.KeyBinds;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="casting", value={Dist.CLIENT})
public class ClientEvents {
    private static boolean lastState = false;

    @SubscribeEvent
    public static void onClientJumping(ClientTickEvent.Pre event) {
        KeyMapping jumpKey = Minecraft.getInstance().options.keyJump;
        boolean isJumping = jumpKey.isDown();
        if (isJumping != lastState) {
            PacketDistributor.sendToServer((CustomPacketPayload)new JetJumpPacket(isJumping), (CustomPacketPayload[])new CustomPacketPayload[0]);
            lastState = isJumping;
        }
    }

    @SubscribeEvent
    public static void onHotKeyPress(InputEvent.Key event) {
        int armorSlot = 0;
        if (KeyBinds.HELMET_HOTKEY.consumeClick()) {
            armorSlot = 1;
        } else if (KeyBinds.CHESTPLATE_HOTKEY.consumeClick()) {
            armorSlot = 2;
        } else if (KeyBinds.LEGGINGS_HOTKEY.consumeClick()) {
            armorSlot = 3;
        } else if (KeyBinds.BOOTS_HOTKEY.consumeClick()) {
            armorSlot = 4;
        }
        if (armorSlot == 0) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ToggleArmorModifiersPayload(armorSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

