/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.event;

import com.benbenlaw.casting.config.EquipmentModifierConfig;
import com.benbenlaw.casting.item.EquipmentModifier;
import com.benbenlaw.casting.util.EquipmentModifierUtils;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;

@EventBusSubscriber(modid="casting")
public class ExperienceEvents {
    @SubscribeEvent
    public static void onPlayerTick(PlayerXpEvent.PickupXp event) {
        Player player = event.getEntity();
        Inventory inventory = player.getInventory();
        ArrayList<ItemStack> itemsWithExpComponent = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !stack.getComponents().keySet().contains(EquipmentModifier.EQUIPMENT_EXPERIENCE.get())) continue;
            itemsWithExpComponent.add(stack);
        }
        int xpValue = event.getOrb().getValue();
        if (!itemsWithExpComponent.isEmpty() && xpValue > 0) {
            Random random = new Random();
            for (int i = 0; i < xpValue; ++i) {
                ItemStack chosen = (ItemStack)itemsWithExpComponent.get(random.nextInt(itemsWithExpComponent.size()));
                int currentExp = Optional.ofNullable((Integer)chosen.getComponents().get((DataComponentType)EquipmentModifier.EQUIPMENT_EXPERIENCE.get())).orElse(0);
                int toolLevel = Optional.ofNullable(Integer.valueOf((Integer)chosen.getComponents().get((DataComponentType)EquipmentModifier.EQUIPMENT_LEVEL.dataComponent.get()))).orElse(0);
                double modifierLevel = EquipmentModifierUtils.getExperienceModifierLevel(toolLevel);
                if (++currentExp >= (int)((double)((Integer)EquipmentModifierConfig.experiencePerLevelForEquipmentLevel.get()).intValue() + (double)((Integer)EquipmentModifierConfig.experiencePerLevelForEquipmentLevel.get()).intValue() * modifierLevel)) {
                    currentExp = 0;
                    int currentLevel = Optional.ofNullable(Integer.valueOf((Integer)chosen.getComponents().get((DataComponentType)EquipmentModifier.EQUIPMENT_LEVEL.dataComponent.get()))).orElse(0);
                    if (currentLevel < (Integer)EquipmentModifierConfig.maxEquipmentLevel.get()) {
                        ++currentLevel;
                    }
                    chosen.set((DataComponentType)EquipmentModifier.EQUIPMENT_LEVEL.dataComponent.get(), (Object)currentLevel);
                }
                chosen.set((DataComponentType)EquipmentModifier.EQUIPMENT_EXPERIENCE.get(), (Object)currentExp);
            }
        }
    }
}

