/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.event;

import com.benbenlaw.casting.item.EquipmentModifier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="casting")
public class DeathEvents {
    public static Map<ItemStack, Integer> soulboundItems = new HashMap<ItemStack, Integer>();

    @SubscribeEvent
    public static void getPlayerInventory(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            NonNullList main = player.getInventory().items;
            for (int i = 0; i < main.size(); ++i) {
                ItemStack stack = (ItemStack)main.get(i);
                if (stack.isEmpty() || !stack.getComponents().has((DataComponentType)EquipmentModifier.SOULBOUND.dataComponent.get())) continue;
                soulboundItems.put(stack.copy(), i);
                stack.setCount(0);
            }
            NonNullList armor = player.getInventory().armor;
            for (int i = 0; i < armor.size(); ++i) {
                ItemStack stack = (ItemStack)armor.get(i);
                if (stack.isEmpty() || !stack.getComponents().has((DataComponentType)EquipmentModifier.SOULBOUND.dataComponent.get())) continue;
                soulboundItems.put(stack.copy(), 36 + i);
                stack.setCount(0);
            }
            NonNullList offhand = player.getInventory().offhand;
            for (int i = 0; i < offhand.size(); ++i) {
                ItemStack stack = (ItemStack)offhand.get(i);
                if (stack.isEmpty() || !stack.getComponents().has((DataComponentType)EquipmentModifier.SOULBOUND.dataComponent.get())) continue;
                soulboundItems.put(stack.copy(), 40 + i);
                stack.setCount(0);
            }
        }
    }

    @SubscribeEvent
    public static void addSoulboundItems(PlayerEvent.PlayerRespawnEvent event) {
        Player entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            for (Map.Entry<ItemStack, Integer> entry : soulboundItems.entrySet()) {
                ItemStack stack = entry.getKey();
                int slotIndex = entry.getValue();
                if (!player.getInventory().getItem(slotIndex).isEmpty()) continue;
                player.getInventory().setItem(slotIndex, stack);
            }
            soulboundItems.clear();
        }
    }
}

