/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.hexlands.world;

import com.alcatrazescapee.hexlands.util.Hex;
import com.alcatrazescapee.hexlands.util.HexSettings;
import com.alcatrazescapee.hexlands.world.HexRandomState;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import org.jetbrains.annotations.Nullable;

public class HexChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final MapCodec<HexChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(c -> c.biomeSource), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(c -> c.settings), (App)HexSettings.CODEC.fieldOf("hex_settings").forGetter(c -> c.hexSettings)).apply((Applicative)instance, HexChunkGenerator::new));
    private final Holder<NoiseGeneratorSettings> settings;
    private final HexSettings hexSettings;
    private final Supplier<Aquifer.FluidPicker> stupidMojangGlobalFluidPicker;

    public HexChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings, HexSettings hexSettings) {
        super(biomeSource, settings);
        this.settings = settings;
        this.hexSettings = hexSettings;
        this.stupidMojangGlobalFluidPicker = Suppliers.memoize(() -> {
            NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)settings.value();
            Aquifer.FluidStatus lavaAtNeg54 = new Aquifer.FluidStatus(-54, Blocks.LAVA.defaultBlockState());
            int seaLevel = noiseGeneratorSettings.seaLevel();
            Aquifer.FluidStatus waterAtSeaLevel = new Aquifer.FluidStatus(seaLevel, noiseGeneratorSettings.defaultFluid());
            return (x, y, z) -> y < Math.min(-54, seaLevel) ? lavaAtNeg54 : waterAtSeaLevel;
        });
    }

    protected MapCodec<HexChunkGenerator> codec() {
        return CODEC;
    }

    public void buildSurface(WorldGenRegion level, StructureManager structureManager, RandomState randomState, ChunkAccess chunk) {
        super.buildSurface(level, structureManager, randomState, chunk);
        NoiseChunk noiseChunk = this.getOrCreateNoiseChunk(chunk, randomState, structureManager, Blender.of((WorldGenRegion)level));
        this.applyAtHexBorders(chunk, randomState, noiseChunk, (cursor, placed) -> {
            Block block;
            int y;
            for (y = placed.minY; y <= placed.borderMinY; ++y) {
                block = chunk.getBlockState((BlockPos)cursor.setY(y)).getBlock();
                if (block == Blocks.BEDROCK) continue;
                chunk.setBlockState((BlockPos)cursor, placed.borderMinState, false);
            }
            for (y = placed.borderMinY + 1; y < placed.borderMaxY; ++y) {
                chunk.setBlockState((BlockPos)cursor.setY(y), Blocks.AIR.defaultBlockState(), false);
            }
            for (y = placed.borderMaxY; y <= placed.maxY; ++y) {
                block = chunk.getBlockState((BlockPos)cursor.setY(y)).getBlock();
                if (block == Blocks.BEDROCK) continue;
                chunk.setBlockState((BlockPos)cursor, placed.borderMaxState, false);
            }
        });
    }

    public int getBaseHeight(int x, int z, Heightmap.Types type, LevelHeightAccessor level, RandomState state) {
        HexRandomState.modify(state, (NoiseGeneratorSettings)this.settings.value(), this.hexSettings);
        return super.getBaseHeight(x, z, type, level, state);
    }

    public void addDebugScreenInfo(List<String> tooltips, RandomState state, BlockPos pos) {
        double hexScale = this.hexSettings.biomeScale();
        double hexSize = this.hexSettings.hexSize() * hexScale;
        Hex hex = Hex.blockToHex((double)pos.getX() * hexScale, (double)pos.getZ() * hexScale, hexSize);
        PlacedHex placed = this.placeHex(hex, state, null, pos.getY());
        tooltips.add(String.format("Hex (%d, %d) at %s : H%d B%d-%d", hex.q(), hex.r(), placed.biome().unwrap().map(ResourceKey::location, e -> "[unregistered biome]"), (int)placed.preliminaryHeight, placed.borderMinY, placed.borderMaxY));
        super.addDebugScreenInfo(tooltips, state, pos);
    }

    private void applyAtHexBorders(ChunkAccess chunk, RandomState state, NoiseChunk noiseChunk, ColumnApplier applier) {
        HashMap<Hex, PlacedHex> cachedBiomesByHex = new HashMap<Hex, PlacedHex>();
        ChunkPos chunkPos = chunk.getPos();
        int blockX = chunkPos.getMinBlockX();
        int blockZ = chunkPos.getMinBlockZ();
        double hexScale = this.hexSettings.biomeScale();
        double hexSize = this.hexSettings.hexSize() * hexScale;
        double hexBorder = this.hexSettings.hexBorderThreshold();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                int x = blockX + localX;
                int z = blockZ + localZ;
                Hex hex = Hex.blockToHex((double)x * hexScale, (double)z * hexScale, hexSize);
                Hex adjacentHex = hex.adjacent((double)x * hexScale, (double)z * hexScale);
                PlacedHex placed = cachedBiomesByHex.computeIfAbsent(hex, k -> this.placeHex((Hex)k, state, noiseChunk, 0));
                if (!(hex.radius((double)x * hexScale, (double)z * hexScale) >= hexBorder)) continue;
                PlacedHex adjacentPlacedHex = cachedBiomesByHex.computeIfAbsent(adjacentHex, k -> this.placeHex((Hex)k, state, noiseChunk, 0));
                if (placed.biome == adjacentPlacedHex.biome) continue;
                cursor.setX(x).setZ(z);
                applier.apply(cursor, placed);
            }
        }
    }

    private PlacedHex placeHex(Hex hex, RandomState state, @Nullable NoiseChunk noiseChunk, int backupSurfaceY) {
        BlockPos center = hex.center();
        double hexScale = this.hexSettings.biomeScale();
        int quartX = QuartPos.fromBlock((int)((int)((double)center.getX() / hexScale)));
        int quartZ = QuartPos.fromBlock((int)((int)((double)center.getZ() / hexScale)));
        NoiseSettings noiseSettings = ((NoiseGeneratorSettings)this.settings.value()).noiseSettings();
        HexRandomState hexRandomState = HexRandomState.modify(state, (NoiseGeneratorSettings)this.settings.value(), this.hexSettings);
        double preliminaryHeight = noiseChunk != null ? (double)noiseChunk.preliminarySurfaceLevel((int)((double)center.getX() / hexScale), (int)((double)center.getZ() / hexScale)) : (double)backupSurfaceY;
        Holder biome = this.biomeSource.getNoiseBiome(quartX, QuartPos.fromBlock((int)((int)preliminaryHeight)), quartZ, hexRandomState.hexSampler());
        XoroshiroRandomSource random = new XoroshiroRandomSource((long)hex.q() * 178293412341L, (long)hex.r() * 7520351231L);
        int minY = noiseSettings.minY();
        int maxY = noiseSettings.minY() + noiseSettings.height() - 1;
        int borderMinY = this.hexSettings.bottomBorder().map(arg_0 -> HexChunkGenerator.lambda$placeHex$10((RandomSource)random, arg_0)).orElse(minY - 1);
        int borderMaxY = this.hexSettings.topBorder().map(arg_0 -> HexChunkGenerator.lambda$placeHex$11((RandomSource)random, arg_0)).orElse(maxY + 1);
        BlockState minBorderState = this.hexSettings.bottomBorder().map(HexSettings.BorderSettings::state).orElse(Blocks.AIR.defaultBlockState());
        BlockState maxBorderState = this.hexSettings.topBorder().map(HexSettings.BorderSettings::state).orElse(Blocks.AIR.defaultBlockState());
        return new PlacedHex(hex, (Holder<Biome>)biome, preliminaryHeight, minY, maxY, borderMinY, borderMaxY, minBorderState, maxBorderState);
    }

    private NoiseChunk getOrCreateNoiseChunk(ChunkAccess chunk, RandomState state, StructureManager structureManager, Blender blender) {
        return chunk.getOrCreateNoiseChunk(c -> NoiseChunk.forChunk((ChunkAccess)c, (RandomState)state, (DensityFunctions.BeardifierOrMarker)Beardifier.forStructuresInChunk((StructureManager)structureManager, (ChunkPos)c.getPos()), (NoiseGeneratorSettings)((NoiseGeneratorSettings)this.settings.value()), (Aquifer.FluidPicker)this.stupidMojangGlobalFluidPicker.get(), (Blender)blender));
    }

    private static /* synthetic */ Integer lambda$placeHex$11(RandomSource random, HexSettings.BorderSettings border) {
        return border.sample(random);
    }

    private static /* synthetic */ Integer lambda$placeHex$10(RandomSource random, HexSettings.BorderSettings border) {
        return border.sample(random);
    }

    @FunctionalInterface
    static interface ColumnApplier {
        public void apply(BlockPos.MutableBlockPos var1, PlacedHex var2);
    }

    record PlacedHex(Hex hex, Holder<Biome> biome, double preliminaryHeight, int minY, int maxY, int borderMinY, int borderMaxY, BlockState borderMinState, BlockState borderMaxState) {
    }
}

