/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.hexlands.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public record HexSettings(double biomeScale, double hexSize, double hexBorderThreshold, Optional<BorderSettings> topBorder, Optional<BorderSettings> bottomBorder) {
    private static final Map<ResourceLocation, HexSettings> DEFAULTS = new Object2ObjectOpenHashMap();
    private static final Codec<HexSettings> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.doubleRange((double)0.01, (double)1000.0).optionalFieldOf("biome_scale", (Object)8.0).forGetter(c -> c.biomeScale), (App)Codec.doubleRange((double)1.0, (double)1000.0).optionalFieldOf("hex_size", (Object)40.0).forGetter(c -> c.hexSize), (App)Codec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("hex_border_threshold", (Object)0.92).forGetter(c -> c.hexBorderThreshold), (App)BorderSettings.CODEC.optionalFieldOf("top_border").forGetter(c -> c.topBorder), (App)BorderSettings.CODEC.optionalFieldOf("bottom_border").forGetter(c -> c.bottomBorder)).apply((Applicative)instance, HexSettings::new));
    public static final Codec<HexSettings> CODEC = Codec.either((Codec)ResourceLocation.CODEC, DIRECT_CODEC).comapFlatMap(e -> (DataResult)e.map(l -> Optional.ofNullable(DEFAULTS.get(l)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No hex_settings named '" + String.valueOf(l) + "'")), DataResult::success), Either::right);

    private static void register(String id, HexSettings settings) {
        DEFAULTS.put(ResourceLocation.fromNamespaceAndPath((String)"hexlands", (String)id), settings);
    }

    static {
        HexSettings.register("overworld", new HexSettings(32.0, 40.0, 0.92, Optional.empty(), BorderSettings.of(62, 66, Blocks.STONE_BRICKS)));
        HexSettings.register("nether", new HexSettings(4.0, 40.0, 0.92, BorderSettings.of(100, 110, Blocks.NETHER_BRICKS), BorderSettings.of(31, 40, Blocks.NETHER_BRICKS)));
        HexSettings.register("the_end", new HexSettings(4.0, 40.0, 0.92, Optional.empty(), Optional.empty()));
    }

    public record BorderSettings(int minHeight, int maxHeight, BlockState state) {
        public static final Codec<BorderSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min_height").forGetter(c -> c.minHeight), (App)Codec.INT.fieldOf("max_height").forGetter(c -> c.maxHeight), (App)BlockState.CODEC.fieldOf("state").forGetter(c -> c.state)).apply((Applicative)instance, BorderSettings::new));

        private static Optional<BorderSettings> of(int minHeight, int maxHeight, Block block) {
            return Optional.of(new BorderSettings(minHeight, maxHeight, block.defaultBlockState()));
        }

        public int sample(RandomSource random) {
            if (this.minHeight == this.maxHeight) {
                return this.minHeight;
            }
            return random.nextIntBetweenInclusive(this.minHeight, this.maxHeight);
        }
    }
}

