/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine;

import dev.djefrey.colorwheel.engine.ClrwlVertexView;
import dev.engine_room.flywheel.api.vertex.MutableVertexList;
import dev.engine_room.flywheel.lib.math.DataPacker;
import dev.engine_room.flywheel.lib.vertex.AbstractVertexView;
import dev.engine_room.flywheel.lib.vertex.DefaultVertexList;
import org.lwjgl.system.MemoryUtil;

public class IrisTerrainVertexView
extends AbstractVertexView
implements DefaultVertexList {
    public static final long STRIDE = 52L;

    public long stride() {
        return 52L;
    }

    public void write(MutableVertexList dst, int srcIndex, int dstIndex) {
        if (dst instanceof ClrwlVertexView) {
            ClrwlVertexView clrwlView = (ClrwlVertexView)dst;
            MemoryUtil.memCopy((long)(this.ptr + (long)srcIndex * 52L), (long)(clrwlView.ptr() + (long)dstIndex * 56L), (long)52L);
            dst.overlay(dstIndex, this.overlay(srcIndex));
            clrwlView.flagWriteAsExtended();
        } else {
            super.write(dst, srcIndex, dstIndex);
        }
    }

    public void write(MutableVertexList dst, int srcStartIndex, int dstStartIndex, int vertexCount) {
        if (dst instanceof ClrwlVertexView) {
            ClrwlVertexView clrwlView = (ClrwlVertexView)dst;
            for (int i = 0; i < vertexCount; ++i) {
                int srcIndex = srcStartIndex + i;
                int dstIndex = dstStartIndex + i;
                MemoryUtil.memCopy((long)(this.ptr + (long)srcIndex * 52L), (long)(clrwlView.ptr() + (long)dstIndex * 56L), (long)52L);
                dst.overlay(dstIndex, this.overlay(i));
            }
            clrwlView.flagWriteAsExtended();
        } else {
            super.write(dst, srcStartIndex, dstStartIndex, vertexCount);
        }
    }

    public float x(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr + (long)index * 52L));
    }

    public float y(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr + (long)index * 52L + 4L));
    }

    public float z(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr + (long)index * 52L + 8L));
    }

    public float r(int index) {
        return DataPacker.unpackNormU8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * 52L + 12L)));
    }

    public float g(int index) {
        return DataPacker.unpackNormU8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * 52L + 13L)));
    }

    public float b(int index) {
        return DataPacker.unpackNormU8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * 52L + 14L)));
    }

    public float a(int index) {
        return DataPacker.unpackNormU8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * 52L + 15L)));
    }

    public float u(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr + (long)index * 52L + 16L));
    }

    public float v(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr + (long)index * 52L + 20L));
    }

    public int light(int index) {
        return MemoryUtil.memGetInt((long)(this.ptr + (long)index * 52L + 24L));
    }

    public float normalX(int index) {
        return DataPacker.unpackNormI8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * 52L + 28L)));
    }

    public float normalY(int index) {
        return DataPacker.unpackNormI8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * 52L + 29L)));
    }

    public float normalZ(int index) {
        return DataPacker.unpackNormI8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * 52L + 30L)));
    }

    public short entityX(int index) {
        return MemoryUtil.memGetShort((long)(this.ptr + (long)index * 52L + 32L));
    }

    public short entityY(int index) {
        return MemoryUtil.memGetShort((long)(this.ptr + (long)index * 52L + 34L));
    }

    public float midU(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr + (long)index * 52L + 38L));
    }

    public float midV(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr + (long)index * 52L + 40L));
    }

    public float tangentX(int index) {
        return DataPacker.unpackNormI8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * 52L + 44L)));
    }

    public float tangentY(int index) {
        return DataPacker.unpackNormI8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * 52L + 45L)));
    }

    public float tangentZ(int index) {
        return DataPacker.unpackNormI8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * 52L + 46L)));
    }

    public float tangentW(int index) {
        return DataPacker.unpackNormI8((byte)MemoryUtil.memGetByte((long)(this.ptr + (long)index * 52L + 47L)));
    }

    public int packedTangent(int index) {
        return MemoryUtil.memGetInt((long)(this.ptr + (long)index * 52L + 44L));
    }

    public byte midBlockX(int index) {
        return MemoryUtil.memGetByte((long)(this.ptr + (long)index * 52L + 48L));
    }

    public byte midBlockY(int index) {
        return MemoryUtil.memGetByte((long)(this.ptr + (long)index * 52L + 49L));
    }

    public byte midBlockZ(int index) {
        return MemoryUtil.memGetByte((long)(this.ptr + (long)index * 52L + 50L));
    }

    public byte midBlockW(int index) {
        return MemoryUtil.memGetByte((long)(this.ptr + (long)index * 52L + 51L));
    }

    public int packedMidBlock(int index) {
        return MemoryUtil.memGetInt((long)(this.ptr + (long)index * 52L + 48L));
    }

    public void x(int index, float x) {
        MemoryUtil.memPutFloat((long)(this.ptr + (long)index * 52L), (float)x);
    }

    public void y(int index, float y) {
        MemoryUtil.memPutFloat((long)(this.ptr + (long)index * 52L + 4L), (float)y);
    }

    public void z(int index, float z) {
        MemoryUtil.memPutFloat((long)(this.ptr + (long)index * 52L + 8L), (float)z);
    }

    public void r(int index, float r) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * 52L + 12L), (byte)DataPacker.packNormU8((float)r));
    }

    public void g(int index, float g) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * 52L + 13L), (byte)DataPacker.packNormU8((float)g));
    }

    public void b(int index, float b) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * 52L + 14L), (byte)DataPacker.packNormU8((float)b));
    }

    public void a(int index, float a) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * 52L + 15L), (byte)DataPacker.packNormU8((float)a));
    }

    public void u(int index, float u) {
        MemoryUtil.memPutFloat((long)(this.ptr + (long)index * 52L + 16L), (float)u);
    }

    public void v(int index, float v) {
        MemoryUtil.memPutFloat((long)(this.ptr + (long)index * 52L + 20L), (float)v);
    }

    public void light(int index, int light) {
        MemoryUtil.memPutInt((long)(this.ptr + (long)index * 52L + 24L), (int)light);
    }

    public void normalX(int index, float normalX) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * 52L + 28L), (byte)DataPacker.packNormI8((float)normalX));
    }

    public void normalY(int index, float normalY) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * 52L + 29L), (byte)DataPacker.packNormI8((float)normalY));
    }

    public void normalZ(int index, float normalZ) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * 52L + 30L), (byte)DataPacker.packNormI8((float)normalZ));
    }

    public void entityX(int index, short entityX) {
        MemoryUtil.memPutShort((long)(this.ptr + (long)index * 52L + 32L), (short)entityX);
    }

    public void entityY(int index, short entityY) {
        MemoryUtil.memPutShort((long)(this.ptr + (long)index * 52L + 34L), (short)entityY);
    }

    public void midU(int index, float midU) {
        MemoryUtil.memPutFloat((long)(this.ptr + (long)index * 52L + 36L), (float)midU);
    }

    public void midV(int index, float midV) {
        MemoryUtil.memPutFloat((long)(this.ptr + (long)index * 52L + 40L), (float)midV);
    }

    public void tangentX(int index, float tangentX) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * 52L + 44L), (byte)DataPacker.packNormI8((float)tangentX));
    }

    public void tangentY(int index, float tangentY) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * 52L + 45L), (byte)DataPacker.packNormI8((float)tangentY));
    }

    public void tangentZ(int index, float tangentZ) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * 52L + 46L), (byte)DataPacker.packNormI8((float)tangentZ));
    }

    public void tangentW(int index, float tangentW) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * 52L + 47L), (byte)DataPacker.packNormI8((float)tangentW));
    }

    public void packedTangent(int index, int packed) {
        MemoryUtil.memPutInt((long)(this.ptr + (long)index * 52L + 44L), (int)packed);
    }

    public void midBlockX(int index, byte midX) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * 52L + 48L), (byte)midX);
    }

    public void midBlockY(int index, byte midY) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * 52L + 49L), (byte)midY);
    }

    public void midBlockZ(int index, byte midZ) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * 52L + 50L), (byte)midZ);
    }

    public void midBlockW(int index, byte midW) {
        MemoryUtil.memPutByte((long)(this.ptr + (long)index * 52L + 51L), (byte)midW);
    }

    public void packedMidBlock(int index, int packed) {
        MemoryUtil.memPutInt((long)(this.ptr + (long)index * 52L + 48L), (int)packed);
    }
}

