/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine;

public record ClrwlInstanceVisual(Type type, int irisId, int lightEmission) {
    private static final int UNDEFINED_ID = -1;
    private static final ClrwlInstanceVisual UNDEFINED = new ClrwlInstanceVisual(Type.UNDEFINED, -1, 0);

    public static ClrwlInstanceVisual undefined() {
        return UNDEFINED;
    }

    public static ClrwlInstanceVisual blockEntity(int irisId, int lightEmission) {
        return new ClrwlInstanceVisual(Type.BLOCKENTITY, irisId, lightEmission);
    }

    public static ClrwlInstanceVisual entity(int irisId) {
        return new ClrwlInstanceVisual(Type.ENTITY, irisId, 0);
    }

    public int getBlockEntity() {
        if (this.type == Type.BLOCKENTITY) {
            return this.irisId;
        }
        return -1;
    }

    public int getEntity() {
        if (this.type == Type.ENTITY) {
            return this.irisId;
        }
        return -1;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ClrwlInstanceVisual) {
            ClrwlInstanceVisual rhs = (ClrwlInstanceVisual)o;
            switch (this.type.ordinal()) {
                case 0: {
                    return rhs.type == Type.UNDEFINED;
                }
                case 1: {
                    return rhs.type == Type.BLOCKENTITY && rhs.irisId == this.irisId;
                }
                case 2: {
                    return rhs.type == Type.ENTITY && rhs.irisId == this.irisId;
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.type.hashCode();
        if (this.type != Type.UNDEFINED) {
            result = prime * result + this.irisId;
        }
        return result;
    }

    public static enum Type {
        UNDEFINED,
        BLOCKENTITY,
        ENTITY;

    }
}

