/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.client.renderer.entities;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.chococraft.ChococraftClient;
import net.chococraft.client.models.entities.AdultChocoboModel;
import net.chococraft.client.models.entities.ChicoboModel;
import net.chococraft.client.renderer.layers.LayerCollar;
import net.chococraft.client.renderer.layers.LayerPlumage;
import net.chococraft.client.renderer.layers.LayerSaddle;
import net.chococraft.common.entity.AbstractChocobo;
import net.chococraft.common.entity.properties.ChocoboColor;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class ChocoboRenderer
extends MobRenderer<AbstractChocobo, EntityModel<AbstractChocobo>> {
    private static final Map<ChocoboColor, ResourceLocation> CHOCOBO_PER_COLOR = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put(ChocoboColor.YELLOW, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chocobos/yellowchocobo.png"));
        map.put(ChocoboColor.GREEN, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chocobos/greenchocobo.png"));
        map.put(ChocoboColor.BLUE, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chocobos/bluechocobo.png"));
        map.put(ChocoboColor.WHITE, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chocobos/whitechocobo.png"));
        map.put(ChocoboColor.BLACK, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chocobos/blackchocobo.png"));
        map.put(ChocoboColor.GOLD, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chocobos/goldchocobo.png"));
        map.put(ChocoboColor.PINK, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chocobos/pinkchocobo.png"));
        map.put(ChocoboColor.RED, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chocobos/redchocobo.png"));
        map.put(ChocoboColor.PURPLE, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chocobos/purplechocobo.png"));
        map.put(ChocoboColor.FLAME, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chocobos/flamechocobo.png"));
    });
    private static final Map<ChocoboColor, ResourceLocation> CHICOBO_PER_COLOR = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put(ChocoboColor.YELLOW, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chicobos/yellowchocobo.png"));
        map.put(ChocoboColor.GREEN, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chicobos/greenchocobo.png"));
        map.put(ChocoboColor.BLUE, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chicobos/bluechocobo.png"));
        map.put(ChocoboColor.WHITE, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chicobos/whitechocobo.png"));
        map.put(ChocoboColor.BLACK, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chicobos/blackchocobo.png"));
        map.put(ChocoboColor.GOLD, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chicobos/goldchocobo.png"));
        map.put(ChocoboColor.PINK, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chicobos/pinkchocobo.png"));
        map.put(ChocoboColor.RED, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chicobos/redchocobo.png"));
        map.put(ChocoboColor.PURPLE, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chicobos/purplechocobo.png"));
        map.put(ChocoboColor.FLAME, ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)"textures/entities/chicobos/flamechocobo.png"));
    });
    private final EntityModel<AbstractChocobo> chicoboModel;
    private final EntityModel<AbstractChocobo> chocoboModel = this.getModel();

    public ChocoboRenderer(EntityRendererProvider.Context context) {
        super(context, new AdultChocoboModel(context.bakeLayer(ChococraftClient.CHOCOBO)), 1.0f);
        this.chicoboModel = new ChicoboModel(context.bakeLayer(ChococraftClient.CHICOBO));
        this.addLayer(new LayerCollar((RenderLayerParent<AbstractChocobo, EntityModel<AbstractChocobo>>)this));
        this.addLayer(new LayerPlumage((RenderLayerParent<AbstractChocobo, EntityModel<AbstractChocobo>>)this));
        this.addLayer(new LayerSaddle((RenderLayerParent<AbstractChocobo, EntityModel<AbstractChocobo>>)this));
    }

    public void render(AbstractChocobo chocobo, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        this.model = chocobo.isBaby() ? this.chicoboModel : this.chocoboModel;
        super.render((LivingEntity)chocobo, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(AbstractChocobo chocobo) {
        ChocoboColor color = chocobo.getChocoboColor();
        return chocobo.isBaby() ? CHICOBO_PER_COLOR.get((Object)color) : CHOCOBO_PER_COLOR.get((Object)color);
    }
}

