/*
 * Decompiled with CFR 0.152.
 */
package com.chen1335.spellColonies.network;

import com.chen1335.spellColonies.SpellColonies;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import dev.kosmx.playerAnim.api.IPlayable;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import io.netty.buffer.ByteBuf;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CitizenPlayAnimationPack(int entityId, ResourceLocation animationLocation, int animationType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CitizenPlayAnimationPack> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"spell_colonies", (String)"citizen_play_animation"));
    public static final StreamCodec<ByteBuf, CitizenPlayAnimationPack> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CitizenPlayAnimationPack::entityId, (StreamCodec)ResourceLocation.STREAM_CODEC, CitizenPlayAnimationPack::animationLocation, (StreamCodec)ByteBufCodecs.INT, CitizenPlayAnimationPack::animationType, CitizenPlayAnimationPack::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handler(IPayloadContext iPayloadContext) {
        Entity entity = iPayloadContext.player().level().getEntity(this.entityId);
        if (entity instanceof AbstractEntityCitizen) {
            AbstractEntityCitizen citizen = (AbstractEntityCitizen)entity;
            IAnimatedPlayer animatedPlayer = (IAnimatedPlayer)citizen;
            if (AnimationType.values()[this.animationType] == AnimationType.IRON_SPELL_BOOK) {
                @Nullable IPlayable toPlayAnimation = PlayerAnimationRegistry.getAnimation((ResourceLocation)this.animationLocation);
                @Nullable ModifierLayer animation = (ModifierLayer)animatedPlayer.playerAnimator_getAnimation(SpellAnimations.ANIMATION_RESOURCE);
                if (this.animationLocation.equals((Object)SpellColonies.EMPTY_ANIMATION)) {
                    animation.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)2, (Ease)Ease.INOUTSINE), null);
                } else {
                    animation.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)2, (Ease)Ease.INOUTSINE), (IAnimation)toPlayAnimation.playAnimation());
                }
            }
        }
    }

    public static enum AnimationType {
        IRON_SPELL_BOOK;

    }
}

