/*
 * Decompiled with CFR 0.152.
 */
package com.chen1335.spellColonies.mixins.main;

import com.minecolonies.api.client.render.modeltype.CitizenModel;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import dev.kosmx.playerAnim.core.impl.AnimationProcessor;
import dev.kosmx.playerAnim.core.util.SetableSupplier;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CitizenModel.class})
public abstract class CitizenModelMixin
extends HumanoidModel<AbstractEntityCitizen> {
    @Unique
    private final SetableSupplier<AnimationProcessor> emoteSupplier = new SetableSupplier();

    public CitizenModelMixin(ModelPart root) {
        super(root);
    }

    @Inject(method={"setupAnim(Lcom/minecolonies/api/entity/citizen/AbstractEntityCitizen;FFFFF)V"}, at={@At(value="HEAD")})
    private void setDefaultBeforeRender(AbstractEntityCitizen citizen, float f1, float f2, float f3, float f4, float f5, CallbackInfo ci) {
        this.setDefaultPivot();
    }

    @Inject(method={"setupAnim(Lcom/minecolonies/api/entity/citizen/AbstractEntityCitizen;FFFFF)V"}, at={@At(value="RETURN")})
    private void updateAnim(AbstractEntityCitizen citizen, float f1, float f2, float f3, float f4, float f5, CallbackInfo ci) {
        IAnimatedPlayer animatedPlayer = (IAnimatedPlayer)citizen;
        AnimationApplier animationApplier = animatedPlayer.playerAnimator_getAnimation();
        if (animationApplier.isActive()) {
            float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            animationApplier.setTickDelta(partialTick);
            this.emoteSupplier.set((Object)animationApplier);
            animationApplier.updatePart("head", this.head);
            this.hat.copyFrom(this.head);
            animationApplier.updatePart("leftArm", this.leftArm);
            animationApplier.updatePart("rightArm", this.rightArm);
            animationApplier.updatePart("leftLeg", this.leftLeg);
            animationApplier.updatePart("rightLeg", this.rightLeg);
            animationApplier.updatePart("torso", this.body);
        }
    }

    @Unique
    private void setDefaultPivot() {
        this.leftLeg.setPos(1.9f, 12.0f, 0.0f);
        this.rightLeg.setPos(-1.9f, 12.0f, 0.0f);
        this.head.setPos(0.0f, 0.0f, 0.0f);
        this.rightArm.z = 0.0f;
        this.rightArm.x = -5.0f;
        this.leftArm.z = 0.0f;
        this.leftArm.x = 5.0f;
        this.body.xRot = 0.0f;
        this.rightLeg.z = 0.1f;
        this.leftLeg.z = 0.1f;
        this.rightLeg.y = 12.0f;
        this.leftLeg.y = 12.0f;
        this.head.y = 0.0f;
        this.head.zRot = 0.0f;
        this.body.y = 0.0f;
        this.body.x = 0.0f;
        this.body.z = 0.0f;
        this.body.yRot = 0.0f;
        this.body.zRot = 0.0f;
        this.head.xScale = 1.0f;
        this.head.yScale = 1.0f;
        this.head.zScale = 1.0f;
        this.body.xScale = 1.0f;
        this.body.yScale = 1.0f;
        this.body.zScale = 1.0f;
        this.rightArm.xScale = 1.0f;
        this.rightArm.yScale = 1.0f;
        this.rightArm.zScale = 1.0f;
        this.leftArm.xScale = 1.0f;
        this.leftArm.yScale = 1.0f;
        this.leftArm.zScale = 1.0f;
        this.rightLeg.xScale = 1.0f;
        this.rightLeg.yScale = 1.0f;
        this.rightLeg.zScale = 1.0f;
        this.leftLeg.xScale = 1.0f;
        this.leftLeg.yScale = 1.0f;
        this.leftLeg.zScale = 1.0f;
    }
}

