/*
 * Decompiled with CFR 0.152.
 */
package com.chen1335.spellColonies.mixins.main;

import com.chen1335.spellColonies.client.animation.CitizenAnimationFactory;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.registries.DataAttachmentRegistry;
import io.redspace.ironsspellbooks.spells.fire.BurningDashSpell;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractEntityCitizen.class})
public abstract class AbstractEntityCitizenMixin
extends LivingEntity
implements IAnimatedPlayer,
IMagicEntity {
    @Unique
    private final Map<ResourceLocation, IAnimation> modAnimationData = new HashMap<ResourceLocation, IAnimation>();
    @Unique
    private final AnimationStack animationStack = this.createAnimationStack();
    @Unique
    private final AnimationApplier animationApplier = new AnimationApplier((IAnimation)this.animationStack);

    protected AbstractEntityCitizenMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Unique
    private AnimationStack createAnimationStack() {
        AnimationStack stack = new AnimationStack();
        CitizenAnimationFactory.ANIMATION_DATA_FACTORY.prepareAnimations((AbstractEntityCitizen)this, stack, this.modAnimationData);
        return stack;
    }

    public AnimationStack getAnimationStack() {
        return this.animationStack;
    }

    public AnimationApplier playerAnimator_getAnimation() {
        return this.animationApplier;
    }

    @Nullable
    public IAnimation playerAnimator_getAnimation(@NotNull ResourceLocation id) {
        return this.modAnimationData.get(id);
    }

    @Nullable
    public IAnimation playerAnimator_setAnimation(@NotNull ResourceLocation id, @Nullable IAnimation animation) {
        if (animation == null) {
            return this.modAnimationData.remove(id);
        }
        return this.modAnimationData.put(id, animation);
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        this.animationStack.tick();
    }

    public MagicData getMagicData() {
        if (!this.hasData((AttachmentType)DataAttachmentRegistry.MAGIC_DATA.get())) {
            this.setData((AttachmentType)DataAttachmentRegistry.MAGIC_DATA.get(), new MagicData(true));
        }
        return (MagicData)this.getData((AttachmentType)DataAttachmentRegistry.MAGIC_DATA.get());
    }

    public void setSyncedSpellData(SyncedSpellData syncedSpellData) {
        if (!this.level().isClientSide) {
            return;
        }
        this.getMagicData().setSyncedData(syncedSpellData);
    }

    public boolean isCasting() {
        return this.getMagicData().isCasting();
    }

    public void initiateCastSpell(AbstractSpell spell, int spellLevel) {
    }

    public void cancelCast() {
    }

    public void castComplete() {
    }

    public void notifyDangerousProjectile(Projectile projectile) {
    }

    public boolean setTeleportLocationBehindTarget(int distance) {
        return false;
    }

    public void setBurningDashDirectionData() {
        this.getMagicData().setAdditionalCastData((ICastData)new BurningDashSpell.BurningDashDirectionOverrideCastData());
    }

    public boolean isDrinkingPotion() {
        return false;
    }

    public boolean getHasUsedSingleAttack() {
        return false;
    }

    public void setHasUsedSingleAttack(boolean bool) {
    }

    public void startDrinkingPotion() {
    }
}

