/*
 * Decompiled with CFR 0.152.
 */
package com.chen1335.spellColonies.client.animation;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CitizenAnimationFactory {
    public static final FactoryHolder ANIMATION_DATA_FACTORY = new FactoryHolder();

    @Nullable
    public IAnimation invoke(@NotNull AbstractEntityCitizen var1);

    public static class FactoryHolder {
        private static final List<Function<AbstractEntityCitizen, DataHolder>> factories = new ArrayList<Function<AbstractEntityCitizen, DataHolder>>();

        private FactoryHolder() {
        }

        public void registerFactory(@Nullable ResourceLocation id, int priority, @NotNull CitizenAnimationFactory factory) {
            factories.add(player -> Optional.ofNullable(factory.invoke((AbstractEntityCitizen)player)).map(animation -> new DataHolder(id, priority, (IAnimation)animation)).orElse(null));
        }

        @ApiStatus.Internal
        public void prepareAnimations(AbstractEntityCitizen player, AnimationStack playerStack, Map<ResourceLocation, IAnimation> animationMap) {
            for (Function<AbstractEntityCitizen, DataHolder> factory : factories) {
                DataHolder dataHolder = factory.apply(player);
                if (dataHolder == null) continue;
                playerStack.addAnimLayer(dataHolder.priority(), dataHolder.animation());
                if (dataHolder.id() == null) continue;
                animationMap.put(dataHolder.id(), dataHolder.animation());
            }
        }

        @ApiStatus.Internal
        private record DataHolder(@Nullable ResourceLocation id, int priority, @NotNull IAnimation animation) {
        }
    }
}

