/*
 * Decompiled with CFR 0.152.
 */
package com.chen1335.spellColonies.ai.workers.guard;

import com.chen1335.spellColonies.SpellColonies;
import com.chen1335.spellColonies.common.events.DefineSpellTypeEvent;
import com.chen1335.spellColonies.mixins.IAbstractSpellMixin;
import com.chen1335.spellColonies.network.CitizenPlayAnimationPack;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.entity.ai.combat.AttackMoveAI;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobCanSee;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveAwayFromLocation;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveToLocation;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerRecasts;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.registries.DataAttachmentRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.jetbrains.annotations.NotNull;

public class MagicianCombatAI
extends AttackMoveAI<EntityCitizen> {
    private final PathingOptions combatPathingOptions;
    private SpellData preferableSpell;
    private MagicData magicData;

    public LivingEntity getCurrentTarget() {
        return this.target;
    }

    public MagicianCombatAI(EntityCitizen owner, ITickRateStateMachine stateMachine) {
        super((Mob)owner, stateMachine);
        if (!owner.hasData((AttachmentType)DataAttachmentRegistry.MAGIC_DATA.get())) {
            owner.setData((AttachmentType)DataAttachmentRegistry.MAGIC_DATA.get(), (Object)new MagicData(true));
        }
        this.magicData = (MagicData)owner.getData((AttachmentType)DataAttachmentRegistry.MAGIC_DATA.get());
        this.magicData.setSyncedData(new SyncedSpellData((LivingEntity)owner));
        this.combatPathingOptions = new PathingOptions();
        this.combatPathingOptions.setEnterDoors(true);
        this.combatPathingOptions.setCanOpenDoors(true);
        this.combatPathingOptions.setCanSwim(true);
        this.combatPathingOptions.withOnPathCost(0.8);
        this.combatPathingOptions.withJumpCost(0.01);
        this.combatPathingOptions.withDropCost(1.5);
    }

    private void playCastAnimation(AbstractSpell spell, boolean isStart) {
        if (!((EntityCitizen)this.user).level().isClientSide) {
            Optional optional;
            Optional optional2 = optional = isStart ? spell.getCastStartAnimation().getForPlayer() : spell.getCastFinishAnimation().getForPlayer();
            if (optional.isPresent()) {
                ResourceLocation resourceLocation = (ResourceLocation)optional.get();
                ServerLevel serverLevel = (ServerLevel)((EntityCitizen)this.user).level();
                serverLevel.getChunkSource().broadcast((Entity)this.user, (CustomPacketPayload)new CitizenPlayAnimationPack(((EntityCitizen)this.user).getId(), resourceLocation, CitizenPlayAnimationPack.AnimationType.IRON_SPELL_BOOK.ordinal()));
            } else {
                ServerLevel serverLevel = (ServerLevel)((EntityCitizen)this.user).level();
                serverLevel.getChunkSource().broadcast((Entity)this.user, (CustomPacketPayload)new CitizenPlayAnimationPack(((EntityCitizen)this.user).getId(), SpellColonies.EMPTY_ANIMATION, CitizenPlayAnimationPack.AnimationType.IRON_SPELL_BOOK.ordinal()));
            }
        }
    }

    public List<SpellData> getAvailableSpells() {
        ArrayList<SpellData> spells = new ArrayList<SpellData>();
        for (int i = 0; i < ((EntityCitizen)this.user).getInventoryCitizen().getSlots(); ++i) {
            @NotNull ItemStack itemStack = ((EntityCitizen)this.user).getInventoryCitizen().getStackInSlot(i);
            if (!(itemStack.getItem() instanceof Scroll)) continue;
            @NotNull SpellData spellData = ISpellContainer.getOrCreate((ItemStack)itemStack).getSpellAtIndex(0);
            if (this.magicData.getPlayerCooldowns().isOnCooldown(spellData.getSpell())) continue;
            spells.add(spellData);
        }
        return spells;
    }

    protected boolean isInDistanceForAttack(LivingEntity target) {
        return true;
    }

    public boolean isEntityValidTarget(LivingEntity target) {
        IMagicSummon magicSummon;
        if (target instanceof IMagicSummon && (magicSummon = (IMagicSummon)target).isAlliedHelper((Entity)this.user)) {
            return false;
        }
        return super.isEntityValidTarget(target);
    }

    protected void doAttack(LivingEntity target) {
        if (this.magicData.isCasting()) {
            return;
        }
        List<SpellData> spells = this.getAvailableSpells();
        if (spells.isEmpty()) {
            return;
        }
        int i1 = ((EntityCitizen)this.user).getRandom().nextInt(spells.size());
        SpellData spellData = spells.get(i1);
        if (this.preferableSpell != null) {
            spellData = this.preferableSpell;
        }
        AbstractSpell spell = spellData.getSpell();
        int level = spellData.getLevel();
        this.castSpell(spell, level);
    }

    public void castSpell(AbstractSpell spell, int level) {
        if (this.magicData.isCasting()) {
            return;
        }
        if (((EntityCitizen)this.user).getCitizenData() != null) {
            ((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().addXpToSkill(Skill.Intelligence, 1.0, ((EntityCitizen)this.user).getCitizenData());
            ((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().addXpToSkill(Skill.Mana, 0.5, ((EntityCitizen)this.user).getCitizenData());
        }
        if (this.target != null) {
            ((EntityCitizen)this.user).lookAt((Entity)this.target, 180.0f, 180.0f);
        }
        int castTime = spell.getCastTime(level);
        this.playCastAnimation(spell, true);
        spell.checkPreCastConditions(((EntityCitizen)this.user).level(), level, (LivingEntity)this.user, this.magicData);
        if (castTime > 0) {
            this.magicData.initiateCast(spell, level, spell.getEffectiveCastTime(level, (LivingEntity)this.user), CastSource.SPELLBOOK, "");
            if (this.magicData.getCastType() == CastType.CONTINUOUS) {
                spell.onCast(((EntityCitizen)this.user).level(), level, (LivingEntity)this.user, CastSource.MOB, (MagicData)((EntityCitizen)this.user).getData((AttachmentType)DataAttachmentRegistry.MAGIC_DATA.get()));
            }
        } else {
            spell.onCast(((EntityCitizen)this.user).level(), level, (LivingEntity)this.user, CastSource.MOB, (MagicData)((EntityCitizen)this.user).getData((AttachmentType)DataAttachmentRegistry.MAGIC_DATA.get()));
            this.addCooldown(spell);
        }
    }

    public void addCooldown(AbstractSpell spell) {
        int cooldown = MagicianCombatAI.getEffectiveSpellCooldown(spell, (AbstractEntityCitizen)this.user, this.magicData.getCastSource());
        if (((EntityCitizen)this.user).getCitizenData() != null) {
            int mama = ((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Mana);
            cooldown = (int)((float)cooldown * Math.max(1.0f - (float)mama / 50.0f, 0.25f));
        }
        this.magicData.getPlayerCooldowns().addCooldown(spell, cooldown);
    }

    protected int getAttackDelay() {
        return 0;
    }

    protected void onTargetDied(LivingEntity target) {
        if (this.magicData.isCasting()) {
            AbstractSpell spell = SpellRegistry.getSpell((String)this.magicData.getCastingSpellId());
            this.magicData.resetCastingState();
            if (this.magicData.getCastType() == CastType.CONTINUOUS) {
                this.magicData.getPlayerCooldowns().addCooldown(this.magicData.getCastingSpellId(), MagicianCombatAI.getEffectiveSpellCooldown(spell, (AbstractEntityCitizen)this.user, this.magicData.getCastSource()));
            }
            this.playCastAnimation(SpellRegistry.getSpell((String)this.magicData.getCastingSpellId()), false);
        }
    }

    protected PathResult<AbstractPathJob> moveInAttackPosition(LivingEntity target) {
        if (BlockPosUtil.getDistanceSquared((BlockPos)target.blockPosition(), (BlockPos)((EntityCitizen)this.user).blockPosition()) <= 36L) {
            PathJobMoveAwayFromLocation job = new PathJobMoveAwayFromLocation(((EntityCitizen)this.user).level(), ((EntityCitizen)this.user).blockPosition(), target.blockPosition(), 7, (int)((EntityCitizen)this.user).getAttribute(Attributes.FOLLOW_RANGE).getValue(), this.user);
            PathResult pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob((AbstractPathJob)job, null, this.getCombatMovementSpeed(), true);
            job.setPathingOptions(this.combatPathingOptions);
            return pathResult;
        }
        if (BlockPosUtil.getDistance2D((BlockPos)target.blockPosition(), (BlockPos)((EntityCitizen)this.user).blockPosition()) >= 20L) {
            PathJobMoveToLocation job = new PathJobMoveToLocation(((EntityCitizen)this.user).level(), PathfindingUtils.prepareStart((LivingEntity)this.user), target.blockPosition(), 200, this.user);
            PathResult pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob((AbstractPathJob)job, null, this.getCombatMovementSpeed(), true);
            job.setPathingOptions(this.combatPathingOptions);
            return pathResult;
        }
        PathJobCanSee job = new PathJobCanSee(this.user, target, ((EntityCitizen)this.user).level(), ((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getGuardPos((AbstractEntityCitizen)this.user), 40);
        PathResult pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob((AbstractPathJob)job, null, this.getCombatMovementSpeed(), true);
        job.setPathingOptions(this.combatPathingOptions);
        return pathResult;
    }

    private double getCombatMovementSpeed() {
        return 1.0;
    }

    protected double getAttackDistance() {
        return 1.0;
    }

    public void tick() {
        if (this.magicData.isCasting()) {
            AbstractSpell spell = SpellRegistry.getSpell((String)this.magicData.getCastingSpellId());
            if (this.target != null) {
                ((EntityCitizen)this.user).lookAt((Entity)this.target, 180.0f, 180.0f);
            }
            spell.onServerCastTick(((EntityCitizen)this.user).level(), this.magicData.getCastingSpellLevel(), (LivingEntity)this.user, this.magicData);
            if (this.magicData.getCastType() == CastType.CONTINUOUS && (this.magicData.getCastDurationRemaining() + 1) % 10 == 0) {
                spell.onCast(((EntityCitizen)this.user).level(), this.magicData.getCastingSpellLevel(), (LivingEntity)this.user, CastSource.SPELLBOOK, this.magicData);
            }
            if (this.magicData.getCastDurationRemaining() <= 0) {
                PlayerRecasts playerRecasts = this.magicData.getPlayerRecasts();
                if (!playerRecasts.hasRecastForSpell(spell)) {
                    spell.onCast(((EntityCitizen)this.user).level(), this.magicData.getCastingSpellLevel(), (LivingEntity)this.user, CastSource.SPELLBOOK, this.magicData);
                    if (!playerRecasts.hasRecastForSpell(spell)) {
                        this.addCooldown(spell);
                    } else {
                        this.preferableSpell = new SpellData(spell, this.magicData.getCastingSpellLevel());
                    }
                } else {
                    spell.onCast(((EntityCitizen)this.user).level(), this.magicData.getCastingSpellLevel(), (LivingEntity)this.user, CastSource.SPELLBOOK, this.magicData);
                    if (playerRecasts.hasRecastForSpell(spell)) {
                        playerRecasts.decrementRecastCount(spell);
                        if (!playerRecasts.hasRecastForSpell(spell)) {
                            this.addCooldown(spell);
                            this.preferableSpell = null;
                        }
                    } else {
                        this.addCooldown(spell);
                    }
                }
                this.magicData.resetCastingState();
                this.playCastAnimation(spell, false);
            }
            this.magicData.handleCastDuration();
        }
        List<SpellData> availableSpells = this.getAvailableSpells();
        HashMap<AbstractSpell, Integer> spellIntegerMap = new HashMap<AbstractSpell, Integer>();
        for (SpellData spell : availableSpells) {
            spellIntegerMap.put(spell.getSpell(), spell.getLevel());
        }
        Integer level = (Integer)spellIntegerMap.get(SpellRegistry.GREATER_HEAL_SPELL.get());
        if ((double)((EntityCitizen)this.user).getHealth() < (double)((EntityCitizen)this.user).getMaxHealth() * 0.4 && level != null) {
            this.castSpell((AbstractSpell)SpellRegistry.GREATER_HEAL_SPELL.get(), level);
        } else if ((double)((EntityCitizen)this.user).getHealth() < (double)((EntityCitizen)this.user).getMaxHealth() * 0.9) {
            for (SpellData availableSpell : availableSpells) {
                if (!IAbstractSpellMixin.cast(availableSpell.getSpell()).sc$isType(DefineSpellTypeEvent.SpellType.HEAL_SELF)) continue;
                this.castSpell(availableSpell.getSpell(), availableSpell.getLevel());
                break;
            }
        }
        this.magicData.getPlayerCooldowns().tick(1);
    }

    public void resetTarget() {
        super.resetTarget();
        this.magicData.resetCastingState();
        this.playCastAnimation(SpellRegistry.getSpell((String)this.magicData.getCastingSpellId()), false);
    }

    public static int getEffectiveSpellCooldown(AbstractSpell spell, AbstractEntityCitizen entityCitizen, CastSource castSource) {
        double playerCooldownModifier = entityCitizen.getAttributeValue((Holder)AttributeRegistry.COOLDOWN_REDUCTION);
        float itemCoolDownModifer = 1.0f;
        if (castSource == CastSource.SWORD) {
            itemCoolDownModifer = ((Double)ServerConfigs.SWORDS_CD_MULTIPLIER.get()).floatValue();
        }
        return (int)((double)spell.getSpellCooldown() * (2.0 - Utils.softCapFormula((double)playerCooldownModifier)) * (double)itemCoolDownModifer);
    }

    public void setAttackTarget(LivingEntity livingEntity) {
        ((EntityCitizen)this.user).getThreatTable().addThreat(livingEntity, 0);
        this.target = livingEntity;
    }
}

