/*
 * Decompiled with CFR 0.152.
 */
package com.chen1335.spellColonies;

import com.chen1335.API.jobs.MEGuardTypes;
import com.chen1335.API.jobs.MEJobs;
import com.chen1335.spellColonies.client.animation.CitizenAnimationFactory;
import com.chen1335.spellColonies.common.events.DefineSpellTypeEvent;
import com.chen1335.spellColonies.mixins.IAbstractSpellMixin;
import com.chen1335.spellColonies.network.CitizenPlayAnimationPack;
import com.mojang.logging.LogUtils;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AdjustmentModifier;
import dev.kosmx.playerAnim.core.util.Vec3f;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.setup.IronsAdjustmentModifier;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;

@Mod(value="spell_colonies")
public class SpellColonies {
    public static final String MODID = "spell_colonies";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation EMPTY_ANIMATION = ResourceLocation.fromNamespaceAndPath((String)"spell_colonies", (String)"empty_animation");

    public SpellColonies(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::commonSetup);
        MEJobs.DEFERRED_REGISTER.register(modEventBus);
        MEGuardTypes.DEFERRED_REGISTER.register(modEventBus);
        modEventBus.addListener(this::registerPayloadHandlersEvent);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        List<AbstractSpell> healOther = List.of((AbstractSpell)SpellRegistry.BLESSING_OF_LIFE_SPELL.get(), (AbstractSpell)SpellRegistry.HEALING_CIRCLE_SPELL.get());
        List<AbstractSpell> healSelf = List.of((AbstractSpell)SpellRegistry.HEAL_SPELL.get());
        for (Map.Entry entry : SpellRegistry.REGISTRY.entrySet()) {
            AbstractSpell abstractSpell = (AbstractSpell)entry.getValue();
            IAbstractSpellMixin abstractSpellMixin = (IAbstractSpellMixin)abstractSpell;
            if (healOther.contains(abstractSpell)) {
                abstractSpellMixin.sc$defineType(DefineSpellTypeEvent.SpellType.HEAL_OTHER);
            } else if (healSelf.contains(abstractSpell)) {
                abstractSpellMixin.sc$defineType(DefineSpellTypeEvent.SpellType.HEAL_SELF);
            } else {
                abstractSpellMixin.sc$defineType(DefineSpellTypeEvent.SpellType.DAMAGE);
            }
            NeoForge.EVENT_BUS.post((Event)new DefineSpellTypeEvent(abstractSpell, ((ResourceKey)entry.getKey()).location()));
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        CitizenAnimationFactory.ANIMATION_DATA_FACTORY.registerFactory(SpellAnimations.ANIMATION_RESOURCE, 42, abstractEntityCitizen -> {
            ModifierLayer animation = new ModifierLayer();
            IronsAdjustmentModifier.INSTANCE = new IronsAdjustmentModifier((partName, partialTick) -> {
                boolean handleHead = animation.getAnimation() != null && !animation.getAnimation().get3DTransform("head", TransformType.ROTATION, 0.5f, Vec3f.ZERO).equals((Object)Vec3f.ZERO);
                switch (partName) {
                    case "head": {
                        if (handleHead) {
                            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(0.0f, Mth.lerp((float)partialTick.floatValue(), (float)(abstractEntityCitizen.yHeadRotO - abstractEntityCitizen.yBodyRotO), (float)(abstractEntityCitizen.yHeadRot - abstractEntityCitizen.yBodyRot)) * ((float)Math.PI / 180), 0.0f), Vec3f.ZERO));
                        }
                        return Optional.empty();
                    }
                    case "rightArm": 
                    case "leftArm": {
                        float x = Mth.lerp((float)partialTick.floatValue(), (float)abstractEntityCitizen.xRotO, (float)abstractEntityCitizen.getXRot());
                        float y = Mth.lerp((float)partialTick.floatValue(), (float)(abstractEntityCitizen.yHeadRotO - abstractEntityCitizen.yBodyRotO), (float)(abstractEntityCitizen.yHeadRot - abstractEntityCitizen.yBodyRot));
                        return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(x * ((float)Math.PI / 180), y * ((float)Math.PI / 180), 0.0f), Vec3f.ZERO, Vec3f.ZERO));
                    }
                }
                return Optional.empty();
            });
            animation.addModifier((AbstractModifier)IronsAdjustmentModifier.INSTANCE, 0);
            return animation;
        });
    }

    public void registerPayloadHandlersEvent(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(CitizenPlayAnimationPack.TYPE, CitizenPlayAnimationPack.STREAM_CODEC, CitizenPlayAnimationPack::handler);
    }
}

