/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.film.properties;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.util.Codecs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record HSB(float hue, float saturation, float brightness) {
    public static final HSB EMPTY = new HSB(0.0f, 0.0f, 0.0f);
    public static final Codec<HSB> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.floatRange(-1.0f, 1.0f).optionalFieldOf("hue", (Object)Float.valueOf(0.0f)).forGetter(HSB::hue), (App)Codecs.floatRange(-1.0f, 1.0f).optionalFieldOf("saturation", (Object)Float.valueOf(0.0f)).forGetter(HSB::saturation), (App)Codecs.floatRange(-1.0f, 1.0f).optionalFieldOf("brightness", (Object)Float.valueOf(0.0f)).forGetter(HSB::brightness)).apply((Applicative)instance, HSB::new));
    public static final StreamCodec<FriendlyByteBuf, HSB> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, HSB::hue, (StreamCodec)ByteBufCodecs.FLOAT, HSB::saturation, (StreamCodec)ByteBufCodecs.FLOAT, HSB::brightness, HSB::new);

    public HSB {
        Preconditions.checkArgument((hue >= -1.0f && hue <= 1.0f ? 1 : 0) != 0, (Object)"h must be in -1 to 1 range.");
        Preconditions.checkArgument((saturation >= -1.0f && saturation <= 1.0f ? 1 : 0) != 0, (Object)"s must be in -1 to 1 range.");
        Preconditions.checkArgument((brightness >= -1.0f && brightness <= 1.0f ? 1 : 0) != 0, (Object)"b must be in -1 to 1 range.");
    }

    @Override
    public String toString() {
        return "H:%s, S:%s, B:%s".formatted(Float.valueOf(this.hue), Float.valueOf(this.saturation), Float.valueOf(this.brightness));
    }
}

