/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.mixin.client;

import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.client.animation.CameraModelPoses;
import io.github.mortuusars.exposure.client.animation.CameraPoses;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.CameraInHand;
import io.github.mortuusars.exposure.world.camera.CameraOnStand;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.entity.CameraOperator;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public abstract class HumanoidModelMixin<T extends LivingEntity>
extends AgeableListModel<T> {
    @Shadow
    @Final
    public ModelPart leftArm;
    @Shadow
    @Final
    public ModelPart rightArm;
    @Unique
    private float exposure$LeftArmBobbingMultiplier = 1.0f;
    @Unique
    private float exposure$RightArmBobbingMultiplier = 1.0f;

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/AnimationUtils;bobModelPart(Lnet/minecraft/client/model/geom/ModelPart;FF)V", ordinal=0)})
    void onSetupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        CameraHolder holder;
        Camera camera;
        if (!(entity instanceof CameraOperator)) {
            this.exposure$LeftArmBobbingMultiplier = 1.0f;
            this.exposure$RightArmBobbingMultiplier = 1.0f;
            return;
        }
        CameraOperator operator = (CameraOperator)entity;
        Camera camera2 = operator.getActiveExposureCamera();
        if (camera2 instanceof Camera && (camera2 = (camera = camera2).getItemStack().getItem()) instanceof CameraItem) {
            CameraInHand cameraInHand;
            HumanoidArm arm;
            CameraItem item = (CameraItem)((Object)camera2);
            CameraPoses poses = CameraModelPoses.get(item);
            HumanoidArm humanoidArm = arm = camera instanceof CameraInHand && (cameraInHand = (CameraInHand)camera).getHand() == InteractionHand.OFF_HAND ? ((HumanoidArm)Minecraft.getInstance().options.mainHand().get()).getOpposite() : (HumanoidArm)Minecraft.getInstance().options.mainHand().get();
            if (camera instanceof CameraOnStand) {
                CameraOnStand cameraOnStand = (CameraOnStand)camera;
                poses.applyStand((HumanoidModel<?>)((HumanoidModel)this), (LivingEntity)entity, arm, cameraOnStand.getStand());
                this.exposure$LeftArmBobbingMultiplier = 1.0f;
                this.exposure$RightArmBobbingMultiplier = 1.0f;
                return;
            }
            if (item.isInSelfieMode(camera.getItemStack())) {
                poses.applySelfie((HumanoidModel<?>)((HumanoidModel)this), (LivingEntity)entity, arm, false);
                if (arm == HumanoidArm.LEFT) {
                    this.exposure$LeftArmBobbingMultiplier = 0.0f;
                    this.exposure$RightArmBobbingMultiplier = 1.0f;
                } else {
                    this.exposure$LeftArmBobbingMultiplier = 1.0f;
                    this.exposure$RightArmBobbingMultiplier = 0.0f;
                }
                return;
            }
            if (Minecrft.player().equals(entity) && PlatformHelper.isModLoaded("realcamera")) {
                return;
            }
            poses.applyHolding((HumanoidModel<?>)((HumanoidModel)this), (LivingEntity)entity, arm);
            this.exposure$LeftArmBobbingMultiplier = arm == HumanoidArm.LEFT ? 0.1f : 0.5f;
            this.exposure$RightArmBobbingMultiplier = arm == HumanoidArm.RIGHT ? 0.1f : 0.5f;
            return;
        }
        if (entity instanceof CameraHolder && (camera2 = CameraInHand.find(holder = (CameraHolder)entity)) instanceof CameraInHand) {
            Camera camera3 = camera2;
            camera3.ifPresent((arg_0, arg_1) -> this.lambda$onSetupAnim$0((CameraInHand)camera3, entity, arg_0, arg_1));
        }
        this.exposure$LeftArmBobbingMultiplier = 1.0f;
        this.exposure$RightArmBobbingMultiplier = 1.0f;
    }

    @Redirect(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/model/AnimationUtils;bobModelPart(Lnet/minecraft/client/model/geom/ModelPart;FF)V"))
    private void removeBobbing(ModelPart modelPart, float ageInTicks, float multiplier) {
        if (this.exposure$LeftArmBobbingMultiplier != 1.0f && modelPart == this.leftArm) {
            multiplier = this.exposure$LeftArmBobbingMultiplier * -1.0f;
        }
        if (this.exposure$RightArmBobbingMultiplier != 1.0f && modelPart == this.rightArm) {
            multiplier = this.exposure$RightArmBobbingMultiplier;
        }
        AnimationUtils.bobModelPart((ModelPart)modelPart, (float)ageInTicks, (float)multiplier);
    }

    private /* synthetic */ void lambda$onSetupAnim$0(CameraInHand camera, LivingEntity entity, CameraItem item, ItemStack stack) {
        CameraPoses poses = CameraModelPoses.get(item);
        if (item.isDisassembled(stack)) {
            HumanoidArm arm = camera.getHand() == InteractionHand.OFF_HAND ? ((HumanoidArm)Minecraft.getInstance().options.mainHand().get()).getOpposite() : (HumanoidArm)Minecraft.getInstance().options.mainHand().get();
            poses.applyDisassembled((HumanoidModel)this, entity, arm);
        }
    }
}

