/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.mixin.client;

import io.github.mortuusars.exposure.client.input.MouseHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    public abstract Level level();

    @Inject(method={"turn(DD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTurn(double yRot, double xRot, CallbackInfo ci) {
        if (this.level().isClientSide && MouseHandler.onTurnPlayer(xRot, yRot)) {
            ci.cancel();
        }
    }
}

