/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.mixin;

import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.CameraOnStand;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.entity.CameraOperator;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements CameraHolder,
CameraOperator {
    @Unique
    @Nullable
    protected Camera activeExposureCamera;
    @Unique
    protected float oExposureCameraActionAnim = 0.0f;
    @Unique
    protected float exposureCameraActionAnim = 0.0f;

    @Shadow
    public abstract Inventory getInventory();

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public Optional<Player> getPlayerExecutingExposure() {
        return Optional.of((Player)this);
    }

    @Override
    public Optional<Player> getPlayerAwardedForExposure() {
        return Optional.of((Player)this);
    }

    @Override
    @NotNull
    public Entity getExposureAuthorEntity() {
        return this;
    }

    @Override
    public Optional<CameraOperator> getExposureCameraOperator() {
        return Optional.of(this);
    }

    @Override
    @Nullable
    public Camera getActiveExposureCamera() {
        if (this.activeExposureCamera != null && !this.activeExposureCamera.isActive()) {
            return null;
        }
        return this.activeExposureCamera;
    }

    @Override
    public void setActiveExposureCamera(@Nullable Camera camera) {
        this.activeExposureCamera = camera;
    }

    @Override
    public void removeActiveExposureCamera() {
        this.activeExposureCamera = null;
    }

    @Override
    public float getExposureCameraActionAnim(float partialTick) {
        float delta = this.exposureCameraActionAnim - this.oExposureCameraActionAnim;
        if (delta < 0.0f) {
            delta += 1.0f;
        }
        return this.oExposureCameraActionAnim + delta * partialTick;
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (!this.level().isClientSide() && this.activeExposureCamera != null && !this.activeExposureCamera.isActive()) {
            this.activeExposureCamera.deactivate();
            this.removeActiveExposureCamera();
        }
        this.oExposureCameraActionAnim = this.exposureCameraActionAnim;
        long lastActionTime = -1L;
        if (this.activeExposureCamera != null) {
            lastActionTime = this.activeExposureCamera.map(CameraItem::getLastActionTime).orElse(-1L);
        } else {
            Item item = this.getMainHandItem().getItem();
            if (item instanceof CameraItem) {
                CameraItem item2 = (CameraItem)item;
                lastActionTime = item2.getLastActionTime(this.getMainHandItem());
            } else {
                item = this.getOffhandItem().getItem();
                if (item instanceof CameraItem) {
                    CameraItem item3 = (CameraItem)item;
                    lastActionTime = item3.getLastActionTime(this.getOffhandItem());
                }
            }
        }
        int actionTime = (int)(this.level().getGameTime() - lastActionTime);
        this.exposureCameraActionAnim = Math.clamp((float)actionTime / 10.0f, 0.0f, 1.0f);
    }

    @Inject(method={"blockActionRestricted(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/GameType;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onBlockActionRestricted(Level level, BlockPos pos, GameType gameMode, CallbackInfoReturnable<Boolean> cir) {
        if (this.getActiveExposureCamera() instanceof CameraOnStand) {
            cir.setReturnValue((Object)true);
        }
    }
}

