/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.util.bugger;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.mortuusars.exposure.client.gui.screen.test.TestImageScreen;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.client.util.bugger.JsonSyntaxHighlighter;
import io.github.mortuusars.exposure.mixin.client.BuggerScreenRenderLinesInvoker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Bugger {
    public static int page = -1;
    private static int zoom;
    private static int scroll;

    public static boolean onKeyPress(int key, int scanCode, int modifiers) {
        if (key == 265) {
            Bugger.up();
        }
        if (key == 264) {
            Bugger.down();
        }
        if (key == 260) {
            zoom = 0;
        }
        if (key == 268) {
            scroll = 0;
        }
        if (key == 263) {
            page = Mth.clamp((int)(page - 1), (int)-1, (int)1);
        }
        if (key == 262) {
            page = Mth.clamp((int)(page + 1), (int)-1, (int)1);
        }
        if (key == 269) {
            Bugger.test();
        }
        return false;
    }

    public static boolean onKeyRepeat(int key, int scanCode, int modifiers) {
        if (key == 265) {
            Bugger.up();
        }
        if (key == 264) {
            Bugger.down();
        }
        if (key == 263) {
            page = Mth.clamp((int)(page - 1), (int)-1, (int)1);
        }
        if (key == 262) {
            page = Mth.clamp((int)(page + 1), (int)-1, (int)1);
        }
        return false;
    }

    public static boolean onKeyRelease(int key, int scanCode, int modifiers) {
        return false;
    }

    private static void test() {
        Minecrft.get().setScreen((Screen)new TestImageScreen());
    }

    private static void up() {
        if (Screen.hasControlDown()) {
            boolean shift = Screen.hasShiftDown();
            zoom = shift ? zoom + 5 : zoom + 1;
        } else {
            boolean shift = Screen.hasShiftDown();
            scroll = Math.max(shift ? scroll - 5 : scroll - 1, 0);
        }
    }

    private static void down() {
        if (Screen.hasControlDown()) {
            boolean shift = Screen.hasShiftDown();
            zoom = shift ? zoom - 5 : zoom - 1;
        } else {
            boolean shift = Screen.hasShiftDown();
            scroll = Math.max(shift ? scroll + 5 : scroll + 1, 0);
        }
    }

    public static void renderMainPage(GuiGraphics guiGraphics) {
        float scale = (float)(zoom + 100) / 100.0f;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scale, scale, scale);
        List<String> leftLines = Bugger.collectLeftLines().stream().skip(scroll).toList();
        ((BuggerScreenRenderLinesInvoker)Minecraft.getInstance().getDebugOverlay()).drawLines(guiGraphics, leftLines, true);
        List<String> rightLines = Bugger.collectRightLines().stream().skip(scroll).toList();
        ((BuggerScreenRenderLinesInvoker)Minecraft.getInstance().getDebugOverlay()).drawLines(guiGraphics, rightLines, false);
        guiGraphics.pose().popPose();
    }

    private static List<String> collectLeftLines() {
        ArrayList<String> lines = new ArrayList<String>();
        return lines;
    }

    private static List<String> collectRightLines() {
        ArrayList<String> lines = new ArrayList<String>();
        return lines;
    }

    private static ItemStack getItemInHand() {
        @Nullable LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return ItemStack.EMPTY;
        }
        ItemStack mainHandItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        return mainHandItem.isEmpty() ? player.getItemInHand(InteractionHand.OFF_HAND) : mainHandItem;
    }

    public static List<String> splitString(String text, int size) {
        ArrayList<String> ret = new ArrayList<String>((text.length() + size - 1) / size);
        for (int start = 0; start < text.length(); start += size) {
            ret.add(text.substring(start, Math.min(text.length(), start + size)));
        }
        return ret;
    }

    public static void renderTagPage(GuiGraphics guiGraphics) {
        List<String> tagLines = Bugger.getTagPageLines();
        int maxScroll = Math.max(tagLines.size() - 8, 0);
        scroll = Mth.clamp((int)scroll, (int)0, (int)maxScroll);
        List<String> lines = tagLines.stream().skip(scroll).toList();
        float scale = (float)(zoom + 100) / 100.0f;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scale, scale, scale);
        ((BuggerScreenRenderLinesInvoker)Minecrft.get().getDebugOverlay()).drawLines(guiGraphics, lines, true);
        guiGraphics.pose().popPose();
    }

    @NotNull
    private static List<String> getTagPageLines() {
        @Nullable HitResult hitResult = Minecrft.get().hitResult;
        if (hitResult == null || hitResult.getType() == HitResult.Type.MISS) {
            ItemStack itemInHand = Bugger.getItemInHand();
            JsonElement json = (JsonElement)ItemStack.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)itemInHand).result().orElse(new JsonObject());
            String jsonString = new GsonBuilder().setPrettyPrinting().create().toJson(json);
            jsonString = JsonSyntaxHighlighter.highlight(jsonString);
            ArrayList<String> lines = new ArrayList<String>(Arrays.stream(jsonString.split("\n")).toList());
            lines.addFirst("");
            lines.addFirst(itemInHand.getHoverName().getString());
            return lines;
        }
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockPos blockPos = blockHitResult.getBlockPos();
            @Nullable BlockEntity blockEntity = Minecrft.level().getBlockEntity(blockPos);
            if (blockEntity != null) {
                CompoundTag beTag = blockEntity.saveWithFullMetadata((HolderLookup.Provider)Minecrft.level().registryAccess());
                JsonElement json = (JsonElement)CompoundTag.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)beTag).result().orElse(new JsonObject());
                String jsonString = new GsonBuilder().setPrettyPrinting().create().toJson(json);
                jsonString = JsonSyntaxHighlighter.highlight(jsonString);
                ArrayList<String> lines = new ArrayList<String>(Arrays.stream(jsonString.split("\n")).toList());
                lines.addFirst("");
                lines.addFirst(blockEntity.getBlockState().getBlock().getName().getString());
                return lines;
            }
            return List.of(Minecrft.level().getBlockState(blockPos).getBlock().getName().getString());
        }
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            Entity entity = entityHitResult.getEntity();
            CompoundTag entityTag = new CompoundTag();
            entity.save(entityTag);
            JsonElement json = (JsonElement)CompoundTag.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entityTag).result().orElse(new JsonObject());
            String jsonString = new GsonBuilder().setPrettyPrinting().create().toJson(json);
            jsonString = JsonSyntaxHighlighter.highlight(jsonString);
            ArrayList<String> lines = new ArrayList<String>(Arrays.stream(jsonString.split("\n")).toList());
            lines.addFirst("");
            lines.addFirst(entity.getName().getString());
            return lines;
        }
        return Collections.emptyList();
    }
}

