/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.renderable;

import io.github.mortuusars.exposure.Exposure;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;

public record RenderableImageIdentifier(String base, String variant) {
    public RenderableImageIdentifier(String base) {
        this(base, "");
    }

    public RenderableImageIdentifier appendVariant(String appendedVariant) {
        if (StringUtil.isBlank((String)appendedVariant)) {
            return this;
        }
        if (StringUtil.isBlank((String)this.variant)) {
            return new RenderableImageIdentifier(this.base, appendedVariant);
        }
        return new RenderableImageIdentifier(this.base, this.variant + "_" + appendedVariant);
    }

    public ResourceLocation toResourceLocation() {
        String path = StringUtil.isBlank((String)this.variant) ? this.base : this.base + "/" + this.variant;
        String validPath = Util.sanitizeName((String)path, ResourceLocation::validPathChar);
        return Exposure.resource(validPath);
    }
}

