/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.items;

import com.scouter.netherdepthsupgrade.entity.entities.LavaFishingBobberEntity;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class LavaFishingRodItem
extends FishingRodItem {
    public LavaFishingRodItem(Item.Properties p_41285_) {
        super(p_41285_);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (pPlayer.fishing != null) {
            if (!pLevel.isClientSide) {
                int i = pPlayer.fishing.retrieve(itemstack);
                itemstack.hurtAndBreak(i, (LivingEntity)pPlayer, LivingEntity.getSlotForHand((InteractionHand)pHand));
            }
            pLevel.playSound((Player)null, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (pLevel.getRandom().nextFloat() * 0.4f + 0.8f));
            pPlayer.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        } else {
            pLevel.playSound((Player)null, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (pLevel.getRandom().nextFloat() * 0.4f + 0.8f));
            if (!pLevel.isClientSide) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                int lure = (int)(EnchantmentHelper.getFishingTimeReduction((ServerLevel)serverLevel, (ItemStack)itemstack, (Entity)pPlayer) * 20.0f);
                int luck = EnchantmentHelper.getFishingLuckBonus((ServerLevel)serverLevel, (ItemStack)itemstack, (Entity)pPlayer);
                pLevel.addFreshEntity((Entity)new LavaFishingBobberEntity(pPlayer, pLevel, luck, lure));
            }
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
            pPlayer.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)pLevel.isClientSide());
    }

    public int getEnchantmentValue() {
        return 5;
    }
}

