/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.scouter.netherdepthsupgrade.NetherDepthsUpgrade;
import com.scouter.netherdepthsupgrade.entity.entities.LavaFishingBobberEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class LavaFishingBobberRenderer
extends EntityRenderer<LavaFishingBobberEntity> {
    private static final ResourceLocation TEXTURE_LOCATION = NetherDepthsUpgrade.prefix("textures/entity/lava_fishing_hook.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutout((ResourceLocation)TEXTURE_LOCATION);
    private static final double VIEW_BOBBING_SCALE = 960.0;

    public LavaFishingBobberRenderer(EntityRendererProvider.Context p_174117_) {
        super(p_174117_);
    }

    public void render(LavaFishingBobberEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        Player player = pEntity.getPlayerOwner();
        if (player != null) {
            float f3;
            double d6;
            double d5;
            double d4;
            pMatrixStack.pushPose();
            pMatrixStack.pushPose();
            pMatrixStack.scale(0.5f, 0.5f, 0.5f);
            pMatrixStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            PoseStack.Pose posestack$pose = pMatrixStack.last();
            VertexConsumer vertexconsumer = pBuffer.getBuffer(RENDER_TYPE);
            LavaFishingBobberRenderer.vertex(vertexconsumer, posestack$pose, pPackedLight, 0.0f, 0, 0, 1);
            LavaFishingBobberRenderer.vertex(vertexconsumer, posestack$pose, pPackedLight, 1.0f, 0, 1, 1);
            LavaFishingBobberRenderer.vertex(vertexconsumer, posestack$pose, pPackedLight, 1.0f, 1, 1, 0);
            LavaFishingBobberRenderer.vertex(vertexconsumer, posestack$pose, pPackedLight, 0.0f, 1, 0, 0);
            pMatrixStack.popPose();
            int i = player.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
            ItemStack itemstack = player.getMainHandItem();
            if (!(itemstack.getItem() instanceof FishingRodItem)) {
                i = -i;
            }
            float f = player.getAttackAnim(pPartialTicks);
            float f1 = Mth.sin((float)(Mth.sqrt((float)f) * (float)Math.PI));
            float f2 = Mth.lerp((float)pPartialTicks, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
            double d0 = Mth.sin((float)f2);
            double d1 = Mth.cos((float)f2);
            double d2 = (double)i * 0.35;
            double d3 = 0.8;
            if ((this.entityRenderDispatcher.options == null || this.entityRenderDispatcher.options.getCameraType().isFirstPerson()) && player == Minecraft.getInstance().player) {
                double d7 = 960.0 / (double)((Integer)this.entityRenderDispatcher.options.fov().get()).intValue();
                Vec3 vec3 = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)i * 0.525f, -0.1f);
                vec3 = vec3.scale(d7);
                vec3 = vec3.yRot(f1 * 0.5f);
                vec3 = vec3.xRot(-f1 * 0.7f);
                d4 = Mth.lerp((double)pPartialTicks, (double)player.xo, (double)player.getX()) + vec3.x;
                d5 = Mth.lerp((double)pPartialTicks, (double)player.yo, (double)player.getY()) + vec3.y;
                d6 = Mth.lerp((double)pPartialTicks, (double)player.zo, (double)player.getZ()) + vec3.z;
                f3 = player.getEyeHeight();
            } else {
                d4 = Mth.lerp((double)pPartialTicks, (double)player.xo, (double)player.getX()) - d1 * d2 - d0 * 0.8;
                d5 = player.yo + (double)player.getEyeHeight() + (player.getY() - player.yo) * (double)pPartialTicks - 0.45;
                d6 = Mth.lerp((double)pPartialTicks, (double)player.zo, (double)player.getZ()) - d0 * d2 + d1 * 0.8;
                f3 = player.isCrouching() ? -0.1875f : 0.0f;
            }
            double d9 = Mth.lerp((double)pPartialTicks, (double)pEntity.xo, (double)pEntity.getX());
            double d10 = Mth.lerp((double)pPartialTicks, (double)pEntity.yo, (double)pEntity.getY()) + 0.25;
            double d8 = Mth.lerp((double)pPartialTicks, (double)pEntity.zo, (double)pEntity.getZ());
            float f4 = (float)(d4 - d9);
            float f5 = (float)(d5 - d10) + f3;
            float f6 = (float)(d6 - d8);
            VertexConsumer vertexconsumer1 = pBuffer.getBuffer(RenderType.lineStrip());
            PoseStack.Pose posestack$pose1 = pMatrixStack.last();
            int j = 16;
            for (int k = 0; k <= 16; ++k) {
                LavaFishingBobberRenderer.stringVertex(f4, f5, f6, vertexconsumer1, posestack$pose1, LavaFishingBobberRenderer.fraction(k, 16), LavaFishingBobberRenderer.fraction(k + 1, 16));
            }
            pMatrixStack.popPose();
            super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        }
    }

    private static float fraction(int p_114691_, int p_114692_) {
        return (float)p_114691_ / (float)p_114692_;
    }

    private static void vertex(VertexConsumer pConsumer, PoseStack.Pose pPose, int pPackedLight, float pX, int pY, int pU, int pV) {
        pConsumer.addVertex(pPose, pX - 0.5f, (float)pY - 0.5f, 0.0f).setColor(-1).setUv((float)pU, (float)pV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(pPackedLight).setNormal(pPose, 0.0f, 1.0f, 0.0f);
    }

    private static void stringVertex(float pX, float pY, float pZ, VertexConsumer pConsumer, PoseStack.Pose pPose, float pStringFraction, float pNextStringFraction) {
        float f = pX * pStringFraction;
        float f1 = pY * (pStringFraction * pStringFraction + pStringFraction) * 0.5f + 0.25f;
        float f2 = pZ * pStringFraction;
        float f3 = pX * pNextStringFraction - f;
        float f4 = pY * (pNextStringFraction * pNextStringFraction + pNextStringFraction) * 0.5f + 0.25f - f1;
        float f5 = pZ * pNextStringFraction - f2;
        float f6 = Mth.sqrt((float)(f3 * f3 + f4 * f4 + f5 * f5));
        pConsumer.addVertex(pPose, f, f1, f2).setColor(-16777216).setNormal(pPose, f3 /= f6, f4 /= f6, f5 /= f6);
    }

    public ResourceLocation getTextureLocation(LavaFishingBobberEntity pEntity) {
        return TEXTURE_LOCATION;
    }
}

