/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.scouter.netherdepthsupgrade.entity.entities.BonefishEntity;
import com.scouter.netherdepthsupgrade.entity.model.BonefishModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class BonefishRenderer
extends GeoEntityRenderer<BonefishEntity> {
    public BonefishRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new BonefishModel());
        this.shadowRadius = 0.3f;
    }

    public RenderType getRenderType(BonefishEntity animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation((Entity)animatable));
    }

    protected void applyRotations(BonefishEntity entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.applyRotations((Entity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        float f = 4.3f * Mth.sin((float)(0.6f * ageInTicks));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(f));
        if (!entityLiving.isInLava()) {
            matrixStackIn.translate((double)0.1f, (double)0.1f, (double)-0.1f);
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }
}

