/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.entities;

import com.mojang.logging.LogUtils;
import com.scouter.netherdepthsupgrade.entity.AbstractLavaFish;
import com.scouter.netherdepthsupgrade.entity.ai.FishSwimGoal;
import com.scouter.netherdepthsupgrade.entity.entities.GlowdineEntity;
import com.scouter.netherdepthsupgrade.items.NDUItems;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FortressGrouperEntity
extends AbstractLavaFish
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final RawAnimation MOVING_FORTRESS_GROUPER = RawAnimation.begin().thenLoop("fortressgrouper.moving");

    public FortressGrouperEntity(EntityType<? extends AbstractLavaFish> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier setAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ARMOR, 10.0).add(Attributes.ATTACK_DAMAGE, 10.0).build();
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.fishSwimGoal = new FishSwimGoal(this);
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, EntitySelector.NO_SPECTATORS::test));
        this.goalSelector.addGoal(3, (Goal)new FishSwimGoal(this));
        this.fishSwimGoal.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.goalSelector.addGoal(4, (Goal)new GulpGoal(this, this, 7.0f));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, GlowdineEntity.class, true, false));
        this.targetSelector.addGoal(4, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 2.0, 20.0f));
    }

    @Override
    public void travel(Vec3 pTravelVector) {
        if (this.isEffectiveAi() && this.isInLava()) {
            this.moveRelative(0.01f, pTravelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(pTravelVector);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "fortressgrouper.moving", 0, state -> state.setAndContinue(MOVING_FORTRESS_GROUPER)));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isPushable() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.COD_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.IRON_GOLEM_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.IRON_GOLEM_HURT;
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.NETHER_BRICKS_FALL;
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)NDUItems.FORTRESS_GROUPER_BUCKET.get());
    }

    class GulpGoal
    extends Goal {
        protected final AbstractLavaFish mob;
        protected final float attackRange;
        protected List<LivingEntity> entityList;

        public GulpGoal(FortressGrouperEntity this$0, AbstractLavaFish fish, float attackRange) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.mob = fish;
            this.attackRange = attackRange;
        }

        public boolean canUse() {
            return this.mob.getTarget() != null && this.mob.distanceToSqr((Entity)this.mob.getTarget()) < (double)(this.attackRange * this.attackRange);
        }

        public boolean canContinueToUse() {
            return this.mob.getTarget() != null && this.mob.getTarget().isAlive() && this.mob.getTarget().distanceToSqr((Entity)this.mob) > (double)(this.attackRange * this.attackRange);
        }

        public void start() {
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void stop() {
            this.mob.fishSwimGoal.trigger();
        }

        public void tick() {
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity != null) {
                double d0 = this.mob.getX();
                double d1 = this.mob.getY();
                double d2 = this.mob.getZ();
                double d3 = livingentity.getX();
                double d4 = livingentity.getY();
                double d5 = livingentity.getZ();
                double moveX = d0 - d3;
                double moveY = d1 - d4;
                double moveZ = d2 - d5;
                Vec3 vec3 = new Vec3(moveX, moveY, moveZ);
                livingentity.setDeltaMovement(vec3.scale(0.05));
                livingentity.hurtMarked = true;
                if (livingentity != null && this.mob.getBoundingBox().inflate(2.0).intersects(livingentity.getBoundingBox())) {
                    this.mob.doHurtTarget((Entity)livingentity);
                }
            }
        }
    }
}

