/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.ai;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.Target;

public class LavaSwimNodeEvaluator
extends NodeEvaluator {
    private final boolean allowBreaching;
    private final Long2ObjectMap<PathType> pathTypesByPosCache = new Long2ObjectOpenHashMap();

    public LavaSwimNodeEvaluator(boolean p_77457_) {
        this.allowBreaching = p_77457_;
    }

    public void prepare(PathNavigationRegion p_192959_, Mob p_192960_) {
        super.prepare(p_192959_, p_192960_);
        this.pathTypesByPosCache.clear();
    }

    public void done() {
        super.done();
        this.pathTypesByPosCache.clear();
    }

    public Node getStart() {
        return super.getNode(Mth.floor((double)this.mob.getBoundingBox().minX), Mth.floor((double)(this.mob.getBoundingBox().minY + 0.5)), Mth.floor((double)this.mob.getBoundingBox().minZ));
    }

    public Target getTarget(double pX, double pY, double pZ) {
        return this.getTargetNodeAt(pX, pY, pZ);
    }

    protected Target getTargetNodeAt(double pX, double pY, double pZ) {
        return new Target(this.getNode(Mth.floor((double)pX), Mth.floor((double)pY), Mth.floor((double)pZ)));
    }

    public int getNeighbors(Node[] p_77483_, Node p_77484_) {
        int i = 0;
        EnumMap map = Maps.newEnumMap(Direction.class);
        for (Direction direction : Direction.values()) {
            Node node = this.findAcceptedNode(p_77484_.x + direction.getStepX(), p_77484_.y + direction.getStepY(), p_77484_.z + direction.getStepZ());
            map.put(direction, node);
            if (!this.isNodeValid(node)) continue;
            p_77483_[i++] = node;
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            Node node1;
            Direction direction2 = direction1.getClockWise();
            if (!LavaSwimNodeEvaluator.hasMalus((Node)map.get(direction1)) || !LavaSwimNodeEvaluator.hasMalus((Node)map.get(direction2)) || !this.isDiagonalNodeValid(node1 = this.findAcceptedNode(p_77484_.x + direction1.getStepX() + direction2.getStepX(), p_77484_.y, p_77484_.z + direction1.getStepZ() + direction2.getStepZ()), (Node)map.get(direction1), (Node)map.get(direction2))) continue;
            p_77483_[i++] = node1;
        }
        return i;
    }

    private static boolean hasMalus(@Nullable Node pNode) {
        return pNode != null && pNode.costMalus >= 0.0f;
    }

    protected boolean isNodeValid(@Nullable Node pNode) {
        return pNode != null && !pNode.closed;
    }

    protected boolean isDiagonalNodeValid(@Nullable Node p_192964_, @Nullable Node p_192965_, @Nullable Node p_192966_) {
        return this.isNodeValid(p_192964_) && p_192965_ != null && p_192965_.costMalus >= 0.0f && p_192966_ != null && p_192966_.costMalus >= 0.0f;
    }

    @Nullable
    protected Node findAcceptedNode(int pX, int pY, int pZ) {
        Node node;
        block7: {
            float f;
            PathType PathType2;
            block6: {
                block5: {
                    node = null;
                    PathType2 = this.getCachedBlockType(pX, pY, pZ);
                    if (!this.allowBreaching) break block5;
                    if (PathType2 == PathType.BREACH) break block6;
                }
                if (PathType2 == PathType.WATER) break block6;
                if (PathType2 != PathType.LAVA) break block7;
            }
            if ((f = this.mob.getPathfindingMalus(PathType2)) >= 0.0f) {
                node = super.getNode(pX, pY, pZ);
                node.type = PathType2;
                node.costMalus = Math.max(node.costMalus, f);
                if (this.mob.level().getFluidState(new BlockPos(pX, pY, pZ)).isEmpty()) {
                    node.costMalus += 8.0f;
                }
            }
        }
        return node;
    }

    protected PathType getCachedBlockType(int pX, int pY, int pZ) {
        return (PathType)this.pathTypesByPosCache.computeIfAbsent(BlockPos.asLong((int)pX, (int)pY, (int)pZ), p_330157_ -> this.getPathType(this.currentContext, pX, pY, pZ));
    }

    public PathType getPathType(PathfindingContext pContext, int pX, int pY, int pZ) {
        return this.getPathTypeOfMob(pContext, pX, pY, pZ, this.mob);
    }

    public PathType getPathTypeOfMob(PathfindingContext pBlockaccess, int pX, int pY, int pZ, Mob pEntityliving) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = pX; i < pX + this.entityWidth; ++i) {
            for (int j = pY; j < pY + this.entityHeight; ++j) {
                int k = pZ;
                if (k >= pZ + this.entityDepth) continue;
                BlockState blockstate = pBlockaccess.getBlockState((BlockPos)blockpos$mutableblockpos.set(i, j, k));
                FluidState fluidstate = blockstate.getFluidState();
                if (fluidstate.isEmpty() && blockstate.isPathfindable(PathComputationType.WATER) && blockstate.isAir()) {
                    return PathType.BREACH;
                }
                return fluidstate.is(FluidTags.LAVA) ? PathType.WATER : PathType.BLOCKED;
            }
        }
        BlockState blockstate1 = pBlockaccess.getBlockState((BlockPos)blockpos$mutableblockpos);
        FluidState fluidState1 = blockstate1.getFluidState();
        return fluidState1.is(FluidTags.LAVA) ? PathType.WATER : PathType.BLOCKED;
    }
}

