/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.ai;

import com.mojang.datafixers.DataFixUtils;
import com.scouter.netherdepthsupgrade.entity.AbstractLavaSchoolingFish;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.ai.goal.Goal;

public class FollowLavaFlockLeaderGoal
extends Goal {
    private static final int INTERVAL_TICKS = 200;
    private final AbstractLavaSchoolingFish mob;
    private int timeToRecalcPath;
    private int nextStartTick;

    public FollowLavaFlockLeaderGoal(AbstractLavaSchoolingFish pFish) {
        this.mob = pFish;
        this.nextStartTick = this.nextStartTick(pFish);
    }

    protected int nextStartTick(AbstractLavaSchoolingFish pTaskOwner) {
        return FollowLavaFlockLeaderGoal.reducedTickDelay((int)(200 + pTaskOwner.getRandom().nextInt(200) % 20));
    }

    public boolean canUse() {
        if (this.mob.hasFollowers()) {
            return false;
        }
        if (this.mob.isFollower()) {
            return true;
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        this.nextStartTick = this.nextStartTick(this.mob);
        Predicate<AbstractLavaSchoolingFish> predicate = p_25258_ -> p_25258_.canBeFollowed() || !p_25258_.isFollower();
        List list = this.mob.level().getEntitiesOfClass(this.mob.getClass(), this.mob.getBoundingBox().inflate(8.0, 8.0, 8.0), predicate);
        AbstractLavaSchoolingFish abstractschoolingfish = (AbstractLavaSchoolingFish)DataFixUtils.orElse(list.stream().filter(AbstractLavaSchoolingFish::canBeFollowed).findAny(), (Object)this.mob);
        abstractschoolingfish.addFollowers(list.stream().filter(p_25255_ -> !p_25255_.isFollower()));
        return this.mob.isFollower();
    }

    public boolean canContinueToUse() {
        return this.mob.isFollower() && this.mob.inRangeOfLeader();
    }

    public void start() {
        this.timeToRecalcPath = 0;
    }

    public void stop() {
        this.mob.stopFollowing();
    }

    public void tick() {
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            this.mob.pathToLeader();
        }
    }
}

