/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.ai;

import com.mojang.logging.LogUtils;
import com.scouter.netherdepthsupgrade.entity.AbstractLavaFish;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class FishSwimGoal
extends RandomStrollGoal {
    private static final Logger LOGGER = LogUtils.getLogger();

    public FishSwimGoal(AbstractLavaFish p_27505_) {
        super((PathfinderMob)p_27505_, 1.0, 40);
    }

    public boolean canUse() {
        if (!this.mob.isInLava() && !this.mob.isInWater() || this.mob.isPassenger() || this.mob.getTarget() != null || !this.mob.isInWater() && !this.mob.isInLava()) {
            return false;
        }
        if (!this.forceTrigger && this.mob.getRandom().nextInt(this.interval) >= 100) {
            return false;
        }
        Vec3 vector3d = this.getPosition();
        if (vector3d == null) {
            return false;
        }
        this.wantedX = vector3d.x;
        this.wantedY = vector3d.y;
        this.wantedZ = vector3d.z;
        this.forceTrigger = false;
        return true;
    }

    @Nullable
    protected Vec3 getPosition() {
        Vec3 vector3d = DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7);
        int i = 0;
        while (vector3d != null && !this.mob.level().getFluidState(BlockPos.containing((Position)vector3d)).is(FluidTags.LAVA) && i++ < 10) {
            vector3d = DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7);
        }
        return vector3d;
    }
}

