/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.datagen;

import com.google.common.collect.ImmutableMap;
import com.scouter.netherdepthsupgrade.blocks.NDUBlocks;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class BlockTagGenerator
extends BlockTagsProvider {
    static final Map<BlockFamily.Variant, BiConsumer<BlockTagGenerator, Block>> SHAPE_CONSUMERS = ImmutableMap.builder().put((Object)BlockFamily.Variant.BUTTON, BlockTagGenerator::addToTag).put((Object)BlockFamily.Variant.DOOR, BlockTagGenerator::addToTag).put((Object)BlockFamily.Variant.CHISELED, BlockTagGenerator::addToTag).put((Object)BlockFamily.Variant.CRACKED, BlockTagGenerator::addToTag).put((Object)BlockFamily.Variant.CUSTOM_FENCE, BlockTagGenerator::addToTag).put((Object)BlockFamily.Variant.FENCE, BlockTagGenerator::addToTagFence).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, BlockTagGenerator::addToTag).put((Object)BlockFamily.Variant.FENCE_GATE, BlockTagGenerator::addToTagFenceGate).put((Object)BlockFamily.Variant.SIGN, BlockTagGenerator::addToTag).put((Object)BlockFamily.Variant.SLAB, BlockTagGenerator::addToTag).put((Object)BlockFamily.Variant.STAIRS, BlockTagGenerator::addToTag).put((Object)BlockFamily.Variant.PRESSURE_PLATE, BlockTagGenerator::addToTag).put((Object)BlockFamily.Variant.TRAPDOOR, BlockTagGenerator::addToTag).put((Object)BlockFamily.Variant.WALL, BlockTagGenerator::addToTagWall).build();

    public BlockTagGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "netherdepthsupgrade", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider pProvider) {
        this.tag(BlockTags.MINEABLE_WITH_HOE).add((Object)((Block)NDUBlocks.WARPED_KELP_BLOCK.get())).add((Object)((Block)NDUBlocks.CRIMSON_KELP_BLOCK.get())).add((Object)((Block)NDUBlocks.WET_LAVA_SPONGE.get())).add((Object)((Block)NDUBlocks.LAVA_SPONGE.get()));
        this.tag(BlockTags.IMPERMEABLE).add((Object)((Block)NDUBlocks.LAVA_GLASS.get()));
    }

    public void addToTag(Block block) {
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)block);
    }

    public void addToTagWall(Block block) {
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)block);
        this.tag(BlockTags.WALLS).add((Object)block);
    }

    public void addToTagFence(Block block) {
        this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object)block);
        this.tag(BlockTags.WOODEN_FENCES).add((Object)block);
        this.tag(BlockTags.FENCES).add((Object)block);
    }

    public void addToTagFenceGate(Block block) {
        this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object)block);
        this.tag(BlockTags.WOODEN_FENCES).add((Object)block);
        this.tag(BlockTags.FENCE_GATES).add((Object)block);
    }
}

