/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.blocks;

import com.mojang.logging.LogUtils;
import com.scouter.netherdepthsupgrade.advancements.NDUAdvancementTriggers;
import com.scouter.netherdepthsupgrade.blocks.NDUBlocks;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class WetLavaSpongeBlock
extends Block {
    private static final Logger LOGGER = LogUtils.getLogger();

    public WetLavaSpongeBlock(BlockBehaviour.Properties p_58222_) {
        super(p_58222_);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        if (pLevel.getBlockState(pPos.above()).getFluidState().is(FluidTags.WATER) && pPlacer instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pPlacer;
            ((ItemUsedOnLocationTrigger)NDUAdvancementTriggers.PLACE_WET_LAVA_SPONGE.get()).trigger(player, pPos, pStack);
        }
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pLevel.getBlockState(pPos.above()).getFluidState().is(FluidTags.WATER)) {
            pLevel.setBlock(pPos, ((Block)NDUBlocks.LAVA_SPONGE.get()).defaultBlockState(), 3);
            pLevel.levelEvent(2009, pPos, 0);
            pLevel.playSound((Player)null, pPos, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 1.0f, (1.0f + pLevel.getRandom().nextFloat() * 0.2f) * 0.7f);
        }
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRand) {
        Direction direction = Direction.getRandom((RandomSource)pRand);
        if (direction != Direction.UP) {
            BlockPos blockpos = pPos.relative(direction);
            BlockState blockstate = pLevel.getBlockState(blockpos);
            if (!pState.canOcclude() || !blockstate.isFaceSturdy((BlockGetter)pLevel, blockpos, direction.getOpposite())) {
                double d0 = pPos.getX();
                double d1 = pPos.getY();
                double d2 = pPos.getZ();
                if (direction == Direction.DOWN) {
                    d1 -= 0.05;
                    d0 += pRand.nextDouble();
                    d2 += pRand.nextDouble();
                } else {
                    d1 += pRand.nextDouble() * 0.8;
                    if (direction.getAxis() == Direction.Axis.X) {
                        d2 += pRand.nextDouble();
                        d0 = direction == Direction.EAST ? (d0 += 1.0) : (d0 += 0.05);
                    } else {
                        d0 += pRand.nextDouble();
                        d2 = direction == Direction.SOUTH ? (d2 += 1.0) : (d2 += 0.05);
                    }
                }
                pLevel.addParticle((ParticleOptions)ParticleTypes.DRIPPING_LAVA, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }
}

