/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.blocks;

import com.scouter.netherdepthsupgrade.blocks.NDUBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class LavaSpongeBlock
extends Block {
    public static final int MAX_DEPTH = 6;
    public static final int MAX_COUNT = 64;
    private static final Direction[] ALL_DIRECTIONS = Direction.values();

    public LavaSpongeBlock(BlockBehaviour.Properties p_56796_) {
        super(p_56796_);
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.is(pState.getBlock())) {
            this.tryAbsorbLava(pLevel, pPos);
        }
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        this.tryAbsorbLava(pLevel, pPos);
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
    }

    protected void tryAbsorbLava(Level pLevel, BlockPos pPos) {
        if (this.removeLavaBreadthFirstSearch(pLevel, pPos)) {
            pLevel.setBlock(pPos, ((Block)NDUBlocks.WET_LAVA_SPONGE.get()).defaultBlockState(), 3);
            pLevel.levelEvent(2001, pPos, Block.getId((BlockState)Blocks.LAVA.defaultBlockState()));
        }
    }

    private boolean removeLavaBreadthFirstSearch(Level pLevel, BlockPos pPos) {
        BlockState spongeState = pLevel.getBlockState(pPos);
        return BlockPos.breadthFirstTraversal((BlockPos)pPos, (int)6, (int)65, (p_277519_, p_277492_) -> {
            for (Direction direction : ALL_DIRECTIONS) {
                p_277492_.accept(p_277519_.relative(direction));
            }
        }, p_279054_ -> {
            BucketPickup bucketpickup;
            if (p_279054_.equals((Object)pPos)) {
                return true;
            }
            BlockState blockstate = pLevel.getBlockState(p_279054_);
            FluidState fluidstate = pLevel.getFluidState(p_279054_);
            Block block = blockstate.getBlock();
            if (blockstate.is(Blocks.WATER)) {
                return false;
            }
            if (block instanceof BucketPickup && !(bucketpickup = (BucketPickup)block).pickupBlock(null, (LevelAccessor)pLevel, p_279054_, blockstate).isEmpty()) {
                return true;
            }
            if (blockstate.getBlock() instanceof LiquidBlock) {
                pLevel.setBlock(p_279054_, Blocks.AIR.defaultBlockState(), 3);
            } else {
                if (!(blockstate.is((Block)NDUBlocks.WARPED_SEAGRASS.get()) || blockstate.is((Block)NDUBlocks.TALL_WARPED_SEAGRASS.get()) || blockstate.is((Block)NDUBlocks.WARPED_KELP.get()) || blockstate.is((Block)NDUBlocks.WARPED_KELP_PLANT.get()))) {
                    return false;
                }
                BlockEntity blockentity = blockstate.hasBlockEntity() ? pLevel.getBlockEntity(p_279054_) : null;
                LavaSpongeBlock.dropResources((BlockState)blockstate, (LevelAccessor)pLevel, (BlockPos)p_279054_, (BlockEntity)blockentity);
                pLevel.setBlock(p_279054_, Blocks.AIR.defaultBlockState(), 3);
            }
            return true;
        }) > 1;
    }
}

