/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.blocks;

import com.mojang.serialization.MapCodec;
import com.scouter.netherdepthsupgrade.blocks.entity.LavaGlassBlockEntity;
import com.scouter.netherdepthsupgrade.blocks.entity.NDUBlockEntities;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LavaGlassBlock
extends BaseEntityBlock {
    protected static final VoxelShape SHAPE_DOWN = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.01, (double)16.0);
    protected static final VoxelShape SHAPE_UP = Block.box((double)0.0, (double)15.99, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.01);
    protected static final VoxelShape SHAPE_EAST = Block.box((double)15.99, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)15.99, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.01, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> occlusionShapes = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.DOWN, SHAPE_DOWN);
            this.put(Direction.UP, SHAPE_UP);
            this.put(Direction.NORTH, SHAPE_NORTH);
            this.put(Direction.EAST, SHAPE_EAST);
            this.put(Direction.SOUTH, SHAPE_SOUTH);
            this.put(Direction.WEST, SHAPE_WEST);
        }
    };
    public static final MapCodec<LavaGlassBlock> CODEC = LavaGlassBlock.simpleCodec(LavaGlassBlock::new);

    public LavaGlassBlock(BlockBehaviour.Properties p_53970_) {
        super(p_53970_);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pLevel.isClientSide) {
            LavaGlassBlockEntity blockEntity = (LavaGlassBlockEntity)pLevel.getBlockEntity(pPos);
            blockEntity.getOcclusionDirs().clear();
            blockEntity.setOcclusionShape(Shapes.empty());
            VoxelShape shape = blockEntity.getOcclusionShape();
            for (Direction direction : Direction.values()) {
                FluidState state = pLevel.getFluidState(pPos.relative(direction));
                if (!state.is(FluidTags.LAVA)) continue;
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)occlusionShapes.get(direction));
                blockEntity.addDirection(direction);
            }
            blockEntity.setOcclusionShape(shape);
        }
        pLevel.sendBlockUpdated(pPos, pState, pState, 8);
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (!pLevel.isClientSide()) {
            LavaGlassBlockEntity blockEntity = (LavaGlassBlockEntity)pLevel.getBlockEntity(pPos);
            blockEntity.getOcclusionDirs().clear();
            blockEntity.setOcclusionShape(Shapes.empty());
            VoxelShape shape = blockEntity.getOcclusionShape();
            for (Direction direction : Direction.values()) {
                if (!pLevel.getFluidState(pPos.relative(direction)).is(FluidTags.LAVA)) continue;
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)occlusionShapes.get(direction));
                blockEntity.addDirection(direction);
            }
            blockEntity.setOcclusionShape(shape);
        }
        pLevel.sendBlockUpdated(pPos, pState, pState, 8);
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
    }

    public VoxelShape getVisualShape(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        LavaGlassBlockEntity blockEntity = (LavaGlassBlockEntity)pLevel.getBlockEntity(pPos);
        if (blockEntity != null) {
            VoxelShape shape = blockEntity.getOcclusionShape();
            return shape;
        }
        return Shapes.empty();
    }

    public boolean skipRendering(BlockState pState, BlockState pAdjacentBlockState, Direction pSide) {
        return pAdjacentBlockState.is((Block)this) ? true : super.skipRendering(pState, pAdjacentBlockState, pSide);
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)NDUBlockEntities.LAVA_GLASS.get()).create(pPos, pState);
    }
}

