/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.blocks;

import com.scouter.netherdepthsupgrade.blocks.GrowingLavaPlantBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public abstract class GrowingLavaPlantHeadBlock
extends GrowingLavaPlantBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_25;
    public static final int MAX_AGE = 25;
    private final double growPerTickProbability;

    protected GrowingLavaPlantHeadBlock(BlockBehaviour.Properties pProperties, Direction pGrowthDirection, VoxelShape pShape, boolean pScheduleFluidTicks, double pGrowPerTickProbability) {
        super(pProperties, pGrowthDirection, pShape, pScheduleFluidTicks);
        this.growPerTickProbability = pGrowPerTickProbability;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public BlockState getStateForPlacement(LevelAccessor pLevel) {
        return (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(pLevel.getRandom().nextInt(25)));
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return (Integer)pState.getValue((Property)AGE) < 25;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockPos blockpos;
        if ((Integer)pState.getValue((Property)AGE) < 25 && CommonHooks.canCropGrow((Level)pLevel, (BlockPos)pPos.relative(this.growthDirection), (BlockState)pState, (pRandom.nextDouble() < this.growPerTickProbability ? 1 : 0) != 0) && this.canGrowInto(pLevel.getBlockState(blockpos = pPos.relative(this.growthDirection)))) {
            pLevel.setBlockAndUpdate(blockpos, this.getGrowIntoState(pState, pLevel.random));
            CommonHooks.fireCropGrowPost((Level)pLevel, (BlockPos)blockpos, (BlockState)pLevel.getBlockState(blockpos));
        }
    }

    protected BlockState getGrowIntoState(BlockState pState, RandomSource pRandom) {
        return (BlockState)pState.cycle((Property)AGE);
    }

    public BlockState getMaxAgeState(BlockState pState) {
        return (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(25));
    }

    public boolean isMaxAge(BlockState pState) {
        return (Integer)pState.getValue((Property)AGE) == 25;
    }

    protected BlockState updateBodyAfterConvertedFromHead(BlockState p_153329_, BlockState p_153330_) {
        return p_153330_;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == this.growthDirection.getOpposite() && !pState.canSurvive((LevelReader)pLevel, pCurrentPos)) {
            pLevel.scheduleTick(pCurrentPos, (Block)this, 1);
        }
        if (pFacing != this.growthDirection || !pFacingState.is((Block)this) && !pFacingState.is(this.getBodyBlock())) {
            if (this.scheduleFluidTicks) {
                pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.LAVA, Fluids.LAVA.getTickDelay((LevelReader)pLevel));
            }
            return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        return this.updateBodyAfterConvertedFromHead(pState, this.getBodyBlock().defaultBlockState());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{AGE});
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return this.canGrowInto(pLevel.getBlockState(pPos.relative(this.growthDirection)));
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRand, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRand, BlockPos pPos, BlockState pState) {
        BlockPos blockpos = pPos.relative(this.growthDirection);
        int i = Math.min((Integer)pState.getValue((Property)AGE) + 1, 25);
        int j = this.getBlocksToGrowWhenBonemealed(pRand);
        for (int k = 0; k < j && this.canGrowInto(pLevel.getBlockState(blockpos)); ++k) {
            pLevel.setBlockAndUpdate(blockpos, (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(i)));
            blockpos = blockpos.relative(this.growthDirection);
            i = Math.min(i + 1, 25);
        }
    }

    protected abstract int getBlocksToGrowWhenBonemealed(RandomSource var1);

    protected abstract boolean canGrowInto(BlockState var1);

    @Override
    protected GrowingLavaPlantHeadBlock getHeadBlock() {
        return this;
    }
}

